/*      SCCS Id: @(#)botl.c     3.1     93/01/17        */
/* Copyright (c) Stichting Mathematisch Centrum, Amsterdam, 1985. */
/* NetHack may be freely redistributed.  See license for details. */

#include "hack.h"

#ifdef OVL0
extern const char *hu_stat[];   /* defined in eat.c */

const char *enc_stat[] = {
	"",
	"Burdened",
	"Stressed",
	"Strained",
	"Overtaxed",
	"Overloaded"
};

static void NDECL(bot1);
static void NDECL(bot2);
#endif /* OVL0 */

/* MAXCO must hold longest uncompressed status line, and must be larger
 * than COLNO
 *
 * longest practical second status line at the moment is
 *      Astral Plane $:12345 HP:700(700) Pw:111(111) AC:-127 Xp:30/123456789
 *      T:123456 Satiated Conf Sick Blind Stun Hallu Overloaded
 * -- or somewhat over 120 characters
 */
#if COLNO <= 130
#define MAXCO 150
#else
#define MAXCO (COLNO+20)
#endif

#ifndef OVLB
STATIC_DCL int mrank_sz;
#else /* OVLB */
STATIC_OVL NEARDATA int mrank_sz = 0; /* loaded by max_rank_sz (from u_init) */
#endif /* OVLB */

struct rank_title {
    char const * const  m;      /* male title */
    char const * const  f;      /* female title, or 0 if same as male */
};
struct class_ranks {
    char                plclass, fill_;
    short               mplayer_class;
    struct rank_title   titles[9];
};

STATIC_DCL const struct rank_title *FDECL(rank_array, (CHAR_P));
STATIC_DCL const char *NDECL(rank);

#ifdef OVL1

/* 9 pairs of ranks for each class */

static const
struct class_ranks all_classes[] = {
  {                                     'A',0,  PM_ARCHEOLOGIST, {
	{"Digger",      0},
	{"Field Worker",0},
	{"Investigator",0},
	{"Exhumer",     0},
	{"Excavator",   0},
	{"Spelunker",   0},
	{"Speleologist",0},
	{"Collector",   0},
	{"Curator",     0}
  } },
  {                                     'B',0,  PM_BARBARIAN, {
	{"Plunderer",   "Plunderess"},
	{"Pillager",    0},
	{"Bandit",      0},
	{"Brigand",     0},
	{"Raider",      0},
	{"Reaver",      0},
	{"Slayer",      0},
	{"Chieftain",   "Chieftainess"},
	{"Conqueror",   "Conqueress"}
  } },
  {                                     'C',0,  PM_CAVEMAN, {
	{"Troglodyte",  0},
	{"Aborigine",   0},
	{"Wanderer",    0},
	{"Vagrant",     0},
	{"Wayfarer",    0},
	{"Roamer",      0},
	{"Nomad",       0},
	{"Rover",       0},
	{"Pioneer",     0}
  } },
  {                                     'D',0,  PM_DOPPELGANGER, {
	{"Copier",         0},
	{"Copier",         0},
	{"Copier",         0},
	{"Shifter",        0},
	{"Shifter",        0},
	{"Changer",        0},
	{"Changer",        0},
	{"Adept Changer",  0},
	{"Master Changer", 0}
  } },
  {                                     'E',0,  PM_ELF, {
	{"Edhel",       "Elleth"},
	{"Edhel",       "Elleth"},      /* elf-maid */
	{"Ohtar",       "Ohtie"},       /* warrior */
	{"Kano",                        /* commander (Q.) ['a] */
			"Kanie"}, /* educated guess, until further research- SAC */
	{"Arandur",               /* king's servant, minister (Q.) - guess */
			"Aranduriel"},  /* educated guess */
	{"Hir",         "Hiril"},       /* lord, lady (S.) ['ir] */
	{"Aredhel",     "Arwen"},       /* noble elf, maiden (S.) */
	{"Ernil",       "Elentariel"},  /* prince (S.), elf-maiden (Q.) */
	{"Elentar",     "Elentari"}     /* Star-king, -queen (Q.) */
  } },
  {                                     'F',0,  PM_FLAME_MAGE, {
	{"Igniter",       0},
	{"Igniter",       0},
	{"Igniter",       0},
	{"Torcher",       0},
	{"Torcher",       0},
	{"Torcher",       0},
	{"Incinerator",   0},
	{"Incinerator",   0},
	{"Flame-Master",  0}
  } },
  {                                     'H',0,  PM_HEALER, {
	{"Rhizotomist",         0},
	{"Empiric",             0},
	{"Embalmer",            0},
	{"Dresser",             0},
	{"Medici ossium",       0},
	{"Herbalist",           0},
	{"Magister",            0},
	{"Physician",           0},
	{"Chirurgeon",          0}
  } },
  {                                     'I',0,  PM_ICE_MAGE, {
	{"Chiller",       0},
	{"Chiller",       0},
	{"Chiller",       0},
	{"Froster",       0},
	{"Froster",       0},
	{"Froster",       0},
	{"Freezer",       0},
	{"Freezer",       0},
	{"Ice-Master",    0}
  } },
  {                                     'K',0,  PM_KNIGHT, {
	{"Gallant",     0},
	{"Esquire",     0},
	{"Bachelor",    0},
	{"Sergeant",    0},
	{"Knight",      0},
	{"Banneret",    0},
	{"Chevalier",   0},
	{"Seignieur",   0},
	{"Paladin",     0}
  } },
  {                                     'L',0,  PM_HUMAN_WEREWOLF, {
	{"Infected",        0},
	{"Summoner",        0},
	{"Stalker",         0},
	{"Render",          0},
	{"Fiend",           0},
	{"Nightmare",       0},
	{"Devourer",        0},
	{"Greater Fiend",   0},
	{"Lycanthrope",     0}
  } },
  {                                     'M',0,  PM_MONK, {
	{"Initiate",           0},
	{"Beginner",           0},
	{"Abbot",              0},
	{"Master of Flowers",  0},
	{"Master of Wind",     0},
	{"Master of Dragons",  0},
	{"Master of Elements", 0},
	{"Master of Spirits",  0},
	{"Grand Master",       0}
  } },
  {                                     'P',0,  PM_PRIEST, {
	{"Aspirant",    0},
	{"Acolyte",     0},
	{"Adept",       0},
	{"Priest",      "Priestess"},
	{"Curate",      0},
	{"Canon",       "Canoness"},
	{"Lama",        0},
	{"Patriarch",   "Matriarch"},
	{"High Priest", "High Priestess"}
  } },
  {                                     'R',0,  PM_ROGUE, {
	{"Footpad",     0},
	{"Cutpurse",    0},
	{"Rogue",       0},
	{"Pilferer",    0},
	{"Robber",      0},
	{"Burglar",     0},
	{"Filcher",     0},
	{"Magsman",     "Magswoman"},
	{"Thief",       0}
  } },
  {                                     'S',0,  PM_SAMURAI, {
	{"Hatamoto",    0},  /* Banner Knight */
	{"Ronin",       0},  /* no allegiance */
	{"Samurai",     0},  /* knight */
	{"Joshu",       0},  /* heads a castle */
	{"Ryoshu",      0},  /* has a territory */
	{"Kokushu",     0},  /* heads a province */
	{"Daimyo",      0},  /* a samurai lord */
	{"Kuge",        0},  /* Noble of the Court */
	{"Shogun",      0}   /* supreme commander, warlord */
  } },
#ifdef TOURIST
  {                                     'T',0,  PM_TOURIST, {
	{"Rambler",     0},
	{"Sightseer",   0},
	{"Excursionist",0},
	{"Peregrinator","Peregrinatrix"},
	{"Traveler",    0},
	{"Journeyer",   0},
	{"Voyager",     0},
	{"Explorer",    0},
	{"Adventurer",  0}
  } },
#endif
  {                                     'U',0,  PM_UNDEAD_SLAYER, {
	{"Assistant",   0},
	{"Eliminator",    0},
	{"Eliminator",    0},
	{"Exterminator",        0},
	{"Exterminator",        0},
	{"Destroyer",   0},
	{"Vindicator",  0},
	{"Vindicator",  0},
	{"Undead Slayer",       0}
  } },
  {                                     'V',0,  PM_VALKYRIE, {
	{"Stripling",   0},
	{"Skirmisher",  0},
	{"Fighter",     0},
	{"Man-at-arms", "Woman-at-arms"},
	{"Warrior",     0},
	{"Swashbuckler",0},
	{"Hero",        "Heroine"},
	{"Champion",    0},
	{"Lord",        "Lady"}
  } },
  {                                     'W',0,  PM_WIZARD, {
	{"Evoker",      0},
	{"Conjurer",    0},
	{"Thaumaturge", 0},
	{"Magician",    0},
	{"Enchanter",   "Enchantress"},
	{"Sorcerer",    "Sorceress"},
	{"Necromancer", 0},
	{"Wizard",      0},
	{"Mage",        0}
  } },
};

STATIC_OVL const struct rank_title *
rank_array(pc)
char pc;
{
	register int i;

	for (i = 0; i < SIZE(all_classes); i++)
	    if (all_classes[i].plclass == pc) return all_classes[i].titles;
	return 0;
}

/* convert experience level (1..30) to rank index (0..8) */
int xlev_to_rank(xlev)
int xlev;
{
	return (xlev <= 2) ? 0 : (xlev <= 30) ? ((xlev + 2) / 4) : 8;
}

#if 0   /* not currently needed */
/* convert rank index (0..8) to experience level (1..30) */
int rank_to_xlev(rank)
int rank;
{
	return (rank <= 0) ? 1 : (rank <= 8) ? ((rank * 4) - 2) : 30;
}
#endif

const char *
rank_of(lev, pc, female)
register unsigned lev;
char pc;
boolean female;
{
	register int idx = xlev_to_rank((int)lev);
	const struct rank_title *ranks = rank_array(pc);

	if (ranks)
	    return( female && ranks[idx].f ? ranks[idx].f : ranks[idx].m );
	return(pl_character);
}

STATIC_OVL const char *
rank()
{
	return(rank_of(u.ulevel, pl_character[0], flags.female));
}

int
title_to_mon(str, rank_indx, title_length)
const char *str;
int *rank_indx, *title_length;
{
	register int i, j;
	register const struct rank_title *ttl;

	for (i = 0; i < SIZE(all_classes); i++)
	    for (j = 0; j < 9; j++) {
		ttl = &all_classes[i].titles[j];
		if (!strncmpi(ttl->m, str, strlen(ttl->m))) {
		    if (rank_indx) *rank_indx = j;
		    if (title_length) *title_length = strlen(ttl->m);
		    return all_classes[i].mplayer_class;
		} else if (ttl->f && !strncmpi(ttl->f, str, strlen(ttl->f))) {
		    if (rank_indx) *rank_indx = j;
		    if (title_length) *title_length = strlen(ttl->f);
		    return all_classes[i].plclass == 'C' ? PM_CAVEWOMAN :
			   all_classes[i].plclass == 'P' ? PM_PRIESTESS :
			   all_classes[i].mplayer_class;
		}
	    }
	return -1;      /* not found */
}

#endif /* OVL1 */
#ifdef OVLB

void
max_rank_sz()
{
	register int i, r, maxr = 0;
	const struct rank_title *ranks = rank_array(pl_character[0]);

	if (ranks) {
	    for (i = 0; i < 9; i++) {
		if ((r = strlen(ranks[i].m)) > maxr) maxr = r;
		if (ranks[i].f)
		    if ((r = strlen(ranks[i].f)) > maxr) maxr = r;
	    }
	    mrank_sz = maxr;
	}
	else mrank_sz = strlen(pl_character);
}

#endif /* OVLB */
#ifdef OVL0

#ifdef SCORE_ON_BOTL
long
botl_score()
{
    int deepest = deepest_lev_reached(FALSE);
    long ugold = u.ugold + hidden_gold();

    if ((ugold -= u.ugold0) < 0L) ugold = 0L;
    return ugold + u.urexp + (long)(50 * (deepest - 1))
			  + (long)(deepest > 30 ? 10000 :
				   deepest > 20 ? 1000*(deepest - 20) : 0);
}
#endif

static void
bot1()
{
	char newbot1[MAXCO];
	register char *nb;
	register int i,j;

	Strcpy(newbot1, plname);
	if('a' <= newbot1[0] && newbot1[0] <= 'z') newbot1[0] += 'A'-'a';
	newbot1[10] = 0;
	Sprintf(nb = eos(newbot1)," the ");
#ifdef POLYSELF
	if (u.mtimedone) {
		char mbot[BUFSZ];
		int k = 0;

		Strcpy(mbot, mons[u.umonnum].mname);
		while(mbot[k] != 0) {
		    if ((k == 0 || (k > 0 && mbot[k-1] == ' ')) &&
					'a' <= mbot[k] && mbot[k] <= 'z')
			mbot[k] += 'A' - 'a';
		    k++;
		}
		Sprintf(nb = eos(nb), mbot);
	} else
		Sprintf(nb = eos(nb), rank());
#else
	Sprintf(nb = eos(nb), rank());
#endif
	Sprintf(nb = eos(nb),"  ");
	i = mrank_sz + 15;
	j = (nb + 2) - newbot1; /* aka strlen(newbot1) but less computation */
	if((i - j) > 0)
		Sprintf(nb = eos(nb),"%*s", i-j, " ");  /* pad with spaces */
	if (ACURR(A_STR) > 18) {
		if (ACURR(A_STR) > 118)
		    Sprintf(nb = eos(nb),"St:%2d ",ACURR(A_STR)-100);
		else if (ACURR(A_STR) < 118)
		    Sprintf(nb = eos(nb), "St:18/%02d ",ACURR(A_STR)-18);
		else
		    Sprintf(nb = eos(nb),"St:18/** ");
	} else
		Sprintf(nb = eos(nb), "St:%-1d ",ACURR(A_STR));
	Sprintf(nb = eos(nb),
		"Dx:%-1d Co:%-1d In:%-1d Wi:%-1d Ch:%-1d",
		ACURR(A_DEX), ACURR(A_CON), ACURR(A_INT), ACURR(A_WIS), ACURR(A_CHA));
	Sprintf(nb = eos(nb), (u.ualign.type == A_CHAOTIC) ? "  Chaotic" :
			(u.ualign.type == A_NEUTRAL) ? "  Neutral" : "  Lawful");
#ifdef SCORE_ON_BOTL
	if (flags.showscore)
	    Sprintf(nb = eos(nb), " S:%ld", botl_score());
#endif
	curs(WIN_STATUS, 1, 0);
	putstr(WIN_STATUS, 0, newbot1);
}

static void
bot2()
{
	char  newbot2[MAXCO];
	register char *nb;
	register int con = ACURR(A_CON), wis = ACURR(A_WIS),
		     intl = ACURR(A_INT);
	int hp, hpmax, cbon, mbon, temp;

/* STEPHEN WHITE'S NEW CODE */

	     if (u.ulevel > 7) temp = 7 + ((u.ulevel - 7) / 2);
	else if (u.ulevel > 14) temp = 10 + ((u.ulevel - 14) / 3);
	else if (u.ulevel > 21) temp = 12 + ((u.ulevel - 21) / 4);
	else if (u.ulevel > 24) temp = 13;
	else temp = u.ulevel;

	if (con == 3) cbon = -3 * temp;
	else if (con == 4) cbon = -2 * temp;
	else if (con == 5) cbon = -2 * temp;
	else if (con == 6) cbon = -1 * temp;
	else if (con == 7) cbon = -1 * temp;
	else if (con < 15) cbon = 0 * temp;  
	else if (con == 15) cbon = 1 * temp;
	else if (con == 16) cbon = 2 * temp;
	else if (con == 17) cbon = 3 * temp;
	else if (con == 18) cbon = 4 * temp;
	else if (con == 19) cbon = 5 * temp;
	else if (con == 20) cbon = 5 * temp;
	else if (con == 21) cbon = 6 * temp;
	else if (con == 22) cbon = 6 * temp; 
	else if (con == 23) cbon = 7 * temp; 
	else if (con == 24) cbon = 7 * temp; 
	else cbon = 8 * temp;
	
	if (wis < 4) mbon = -3 * temp;
	else if (wis < 6) mbon = -2 * temp;
	else if (wis < 8) mbon = -1 * temp;
	else if (wis < 14) mbon = 0 * temp;
	else if (wis == 14) mbon = 1 * temp;
	else if (wis == 15) mbon = 2 * temp;
	else if (wis == 16) mbon = 2 * temp;
	else if (wis == 17) mbon = 3 * temp;
	else if (wis == 18) mbon = 3 * temp;
	else if (wis == 19) mbon = 4 * temp;
	else if (wis == 20) mbon = 4 * temp;
	else if (wis == 21) mbon = 5 * temp;
	else if (wis == 22) mbon = 5 * temp; 
	else if (wis == 23) mbon = 6 * temp; 
	else if (wis == 24) mbon = 6 * temp; 
	else mbon = 7 * temp;
	
	if (intl < 4) mbon += -2 * temp;
	else if (intl < 6) mbon += -1 * temp;
	else if (intl < 17) mbon += 0 * temp;
	else if (intl == 17) mbon += 1 * temp;
	else if (intl == 18) mbon += 1 * temp; 
	else if (intl == 19) mbon += 2 * temp;
	else if (intl == 20) mbon += 2 * temp;
	else if (intl == 21) mbon += 3 * temp;
	else if (intl == 22) mbon += 3 * temp;
	else if (intl == 23) mbon += 4 * temp; 
	else if (intl == 24) mbon += 4 * temp;
	else mbon += 5 * temp;
	
	u.uhpmax = u.uhpbase + cbon;
	if (u.uhpmax < 1) u.uhpmax = 1;
	if (u.uhp > u.uhpmax) u.uhp = u.uhpmax;
	
	u.uenmax = u.uenbase + mbon;
	if (u.uenmax < 0) u.uenmax = 0;
	if (u.uen > u.uenmax) u.uen = u.uenmax;


#ifdef POLYSELF
	hp = u.mtimedone ? u.mh : u.uhp;
	hpmax = u.mtimedone ? u.mhmax : u.uhpmax;
#else

	hp = u.uhp;
	hpmax = u.uhpmax;

#endif
	if(hp < 0) hp = 0;

	Sprintf(newbot2,"AC:%-2d ",u.uac);

	Sprintf(nb = eos(newbot2),
		"HP:%d(%d)  Pw:%d(%d) ",
		hp, hpmax, u.uen, u.uenmax);
#ifdef POLYSELF
	if (u.mtimedone)
		Sprintf(nb = eos(nb), " HD:%d", mons[u.umonnum].mlevel);
	else
#endif
	Sprintf(nb = eos(nb), " Level:%u  Exp:%-1ld(%-1ld)", u.ulevel,u.uexp,newuexp(u.ulevel));
	Sprintf(nb = eos(nb), "  Wt:%ld/%ld",inv_weight()+weight_cap(),weight_cap());
/*	if(strcmp(hu_stat[u.uhs], "        ")) {
		Sprintf(nb = eos(nb), " ");
		Strcat(newbot2, hu_stat[u.uhs]);
	}*/
	curs(WIN_STATUS, 1, 1);
	putstr(WIN_STATUS, 0, newbot2);
}
////////////////////////////////////////////////////////////////////////
static void
bot3()
{
	char  newbot3[MAXCO];
	register char *nb;
	int cap = near_capacity();

/* TODO:        Add in dungeon name */
#ifdef MULDGN
	if(Is_knox(&u.uz)) Sprintf(newbot3, "%s ", dungeons[u.uz.dnum].dname);
	else
	if(In_quest(&u.uz)) Sprintf(newbot3, "Home %d ", dunlev(&u.uz));
	else
#endif
	if(In_endgame(&u.uz))
		Sprintf(newbot3,
			Is_astralevel(&u.uz) ? "Astral Plane " : "End Game ");
	else
		Sprintf(newbot3, "Dlvl:%-2d ", depth(&u.uz));
	Sprintf(nb = eos(newbot3),
		"%c:%-2ld  Score:%d", oc_syms[GOLD_CLASS],
		u.ugold, botl_score());
	Sprintf(nb = eos(nb), "  Turn:%ld", moves);
	if(strcmp(hu_stat[u.uhs], "        ")) {
		Sprintf(nb = eos(nb), "  ");
		Strcat(newbot3, hu_stat[u.uhs]);
	}
	if (Levitation)    Sprintf(nb = eos(nb), " Levitate");
	if(Confusion)      Sprintf(nb = eos(nb), " Conf");
	if(Sick)           Sprintf(nb = eos(nb), " Sick");
	if(Blind)          Sprintf(nb = eos(nb), " Blind");
	if(Stunned)        Sprintf(nb = eos(nb), " Stun");
	if(Hallucination)  Sprintf(nb = eos(nb), " Hallu");
	if(cap > UNENCUMBERED)
		Sprintf(nb = eos(nb), " %s", enc_stat[cap]);
	curs(WIN_STATUS, 1, 2);
	putstr(WIN_STATUS, 0, newbot3);
}

void
bot()
{
	bot1();
	bot2();
	bot3();
	flags.botl = flags.botlx = 0;
}

#endif /* OVL0 */

/*botl.c*/
