/****************************************************************************/
/*                                                                          */
/*	SOUND.H : header for sound functions.                                  */
/*                                                                          */
/*			declare all structures for a sound sample                    */
/*			declare all availabled functions                             */
/*                                                                          */
/*	(c) Herv Soulard, Version 1.0 - 10/01/1991                            */
/*	                   Version 1.1 - 01/02/1991                            */
/*                                                                          */
/****************************************************************************/


#ifndef	byte
#define	byte		unsigned char
#endif

#ifndef _SOUND_H_

#define _SOUND_H_


#define IDENT		"HS PC-Sound file format (V 1.0)"

struct sound {
	char			ident[32];
	byte _huge	*buffer;
	unsigned long	nbValues;
	unsigned int	hertz;
	byte			timer;
	byte			mult;
	char			memo[255];
};

int readSound(char *, struct sound *);
void closeSound(struct sound *);

extern int playSound(struct sound);
extern byte soundDone;

#endif
	