/* This is file vgr.h */

#ifndef _GR_INCLUDED
#define _GR_INCLUDED

typedef unsigned char	uchar;
typedef unsigned int	uint;
typedef unsigned long	ulong;

typedef struct {
	uint	ax;
	uint	bx;
	uint	cx;
	uint	dx;
	uint	si;
	uint	di;
	uint	bp;
	uint	f;
} REGISTERS;

extern int far	int10 (REGISTERS *regs);
extern void far _fastcall _GrSetPage (int pread, int pwrite);
extern uint far _fastcall _GrGetPage (void);
extern uchar far * far _fastcall _GrAddr (uint x, uint y, uint width);
extern uchar far * far _fastcall _GrNewPage (ulong xy);
extern void far _fastcall _GrSetColor (int color, int r, int g, int b);

extern uint	_ReadPage;
extern enum GR_graphics_modes _GrCurMode;
extern uint	_GrSizeX;
extern uint	_GrSizeY;
extern uint	_GrWriteMode;

#ifdef MYMEM
extern void far	vgaput (uint at, uchar far *f, int n);
extern void far	vgaget (uchar far *t, uint af, int n);
extern void far	vgamov (uint at, uint af, int n);
extern void far	vgaset (uint at, int c, int w);
#endif

#include "gr.h"

#endif
