	 .MODEL	 LARGE,C
;
ICR	 EQU	 20H
EOI	 EQU	 20H
;
RXBUF	 EQU	 0
IIR	 EQU	 2
LSR	 EQU	 5
;
ID_MASK  EQU	 7
RX_ID	 EQU	 4
TX_ID	 EQU	 2
;
DGROUP	 GROUP	 _DATA
_DATA	 SEGMENT WORD PUBLIC 'DATA'
	 ASSUME  DS:DGROUP
	 EXTRN	 portbase:WORD
	 EXTRN	 ccbidle:BYTE
_DATA	 ENDS
;
_TEXT	 SEGMENT WORD PUBLIC 'CODE'
	 ASSUME  CS:_TEXT
	 EXTRN	 rcvint:FAR
	 EXTRN	 xmtint:FAR
;
	 PUBLIC  com1_int
com1_int LABEL	 far
	 push	 cx
	 mov	 cx,1
	 jmp	 SHORT com_int
;
	 PUBLIC  com2_int
com2_int LABEL	 far
	 push	 cx
	 mov	 cx,2
	 jmp	 SHORT com_int
;
	 PUBLIC  com3_int
com3_int LABEL	 far
	 push	 cx
	 mov	 cx,3
	 jmp	 SHORT com_int
;
	 PUBLIC  com4_int
com4_int LABEL	 far
	 push	 cx
	 mov	 cx,4
	 jmp	 SHORT com_int
;
com_int:
	 push	 ax
	 push	 bx
	 push	 dx
	 push	 bp
	 push	 si
	 push	 di
	 push	 ds
	 push	 es
;
	 mov	 ax,cs:dssave
	 mov	 ds,ax		; set C ds
	 mov	 es,ax		; set C es
	 mov	 si,cx
	 add	 si,si
check:
	 mov	 dx,portbase[si]
	 add	 dx,IIR		; Interrupt ID reg
	 in	 al,dx		; read IIR
	 and	 al,ID_MASK	; just in case
	 cmp	 al,TX_ID
	 je	 write
	 cmp	 al,RX_ID
	 je	 read
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; see if we lost any interrupts
;
; The problem is that on a 386DX50 the program looses some of the interrupts.
; The result is that xmtr is empty but the expected intr never happens, then
; the output buffer overflows. Same thing happens with lost incoming data
; interrupts. This segment of code directly tests the line status to see if
; there is work to do. If there is data to read then it is read; simple. If
; there is an empty xmtr then we need to know if we have data to send - so
; I added 'ccbidle' which mirrors the 'Idle' status of the corresponding ccb
; (see circbuff.c).
;
	 mov	 dx,portbase[si]
	 add	 dx,LSR
	 in	 al,dx
	 test	 al,001H	; rcvr data ready?
	 jnz	 read
	 test	 al,020H	; xmtr hold reg?
	 jz	 nowrite	; xmtr busy.
	 test	 ccbidle[si],001H	; test ccb status
;	 jz	 write		; ccb has data
	 jnz	 nowrite	; ccb is idle.
	 push	 si
	 push	 cx		; push port number
	 call	 xmtint		; xmtint (int port)
	 pop	 cx
	 pop	 si
nowrite:
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	 mov	 al,EOI
	 out	 ICR,al
;
	 pop	 es
	 pop	 ds
	 pop	 di
	 pop	 si
	 pop	 bp
	 pop	 dx
	 pop	 bx
	 pop	 ax
	 pop	 cx
	 iret
read:
	 mov	 dx,portbase[si]
	 add	 dx,RXBUF	; RX buffer
	 in	 al,dx		; get character
	 xor	 ah,ah		; make an int
	 push	 si
	 push	 ax		; push character
	 push	 cx		; push port number
	 call	 rcvint		; rcvint (int port, int c)
	 pop	 cx
	 pop	 ax
	 pop	 si
	 jmp     SHORT check
write:
	 push	 si
	 push	 cx		; push port number
	 call	 xmtint		; xmtint (int port)
	 pop	 cx
	 pop	 si
	 jmp     SHORT check
;
dssave	 dw	 0
;
	 PUBLIC  intinit
intinit	 PROC	 FAR
	 MOV	 CS:dssave,DS
	 RET
intinit	 ENDP
_TEXT	 ENDS

	 END
