/* --------------------------------- random.c ------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Handler for the random pointing device.
*/

#include <stdlib.h>

#include "fly.h"

static int FAR
read (POINTER *p)
{
	int	i;

	if (p->c[0] > 0)
		p->c[0] -= (p->b[0] = 1);	/* speed up */
	else if (p->c[0] > -10) {
		--p->c[0];
		p->a[1] += 10;
	} else if (p->c[0] > -30) {
		--p->c[0];
		p->a[1] -= 10;
	} else if (p->c[0] > -40) {
		--p->c[0];
		p->a[1] += 10;
	} else {
		p->a[1] = 0;
		p->b[1] = 0;
#if 1
		i = p->a[0];
		if (i < 0)
			++i;
		else if (i > 0)
			--i;
		i += (rand () % 10) - 5;
		if (i > 40)
			i = 80 - i;
		else if (i < -40)
			i = -80 - i;
		p->a[0] = i;
#else
		p->a[0] = 0;
#endif
	}

	return (0);
}

static int FAR
cal (POINTER *p)
{
	p->c[0] = 50;		/* set course for 250 m/s */
	p->b[0] = 0;
	p->b[1] = 0;
	p->a[0] = 0;
	p->a[1] = 0;
	return (0);
}

static void FAR
term (POINTER *p)
{
	return;
}

static void FAR
key (POINTER *p, int key)
{
	return;
}

struct PtrDriver PtrRandom = {
	"RANDOM",
	0,
	cal,			/* init */
	term,
	cal,
	cal,			/* center */
	read,
	key
};
