/* --------------------------------- plane.h -------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Common header for plane dynamics models.
*/

struct e_parms {
	struct e_parms	*next;
	char	name[10];
	short	wing_area;		/* m**2 [ft**2] */
	short	wing_span;		/* ft */
	long	weight;			/* lb (empty) */
	short	mil_thrust;		/* lb_thrust */
	short	mil_sfc;		/* lb_fuel/(lb_thrust*hour) */
	short	ab_thrust;		/* lb_thrust */
	short	ab_sfc;			/* lb_fuel/(lb_thrust*hour) */
	short	liftoff_speed;		/* knots */
	short	max_lift;		/* Gs */
	short	min_lift;		/* Gs */
	ANGLE	pitch_rate;		/* pi*rad/sec [at 300 knots] */
	ANGLE	roll_rate;		/* pi*rad/sec [at 300 knots] */
	short	max_flaps;		/* max flaps */
	short	max_spoilers;		/* max spoilers */
	Ushort	fuel_capacity;		/* internal fuel kg [pounds] */
	short	efficiency_factor;	/* Oswald's efficiency factor */
	short	height;			/* pilot eye's hight [feet]*/
	ANGLE	gpitch;			/* pitch on ground */
	long	ceiling;		/* operational ceiling [feet]*/
	short	stores[N_WE];

	short	BRAKE_MU;		/* friction with brakes applied */
	short	WHEEL_MU;		/* friction when freewheeling */
	ANGLE	Aoffset;		/* Wing rigging angle vs. plane */
	ANGLE	Toffset;		/* Tail rigging angle vs. wing */
	short	Tvol;			/* tail volume */
	short	FEff;			/* degs eff alpha / degs flaps */
	ANGLE	Cl0;			/* alpha where Cl=0 */
	short	MAXLIFT;		/* max Cl for wing foil */
	short	Cdp0;			/* parasitic drag: profile */
	short	Cds;			/* parasitic drag: speed brakes */
	short	Cdg;			/* parasitic drag: gear */
	short	CdMK82;			/* parasitic drag: each MK82 */

	short	MaxElevators;
	short	MaxAilerons;

	short	FXrudder;		/* rudder sideforce */
	short	FXvx;			/* vx damping */

	short	MXelevators;		/* elevators effectiveness */
	short	MXdx;			/* pitch damping */
	short	MXtail;			/* stabilizer induced pitch */
	short	MXlift;			/* lift induced pitch */
	short	MXdrag;			/* drag induced pitch */
	short	MXthrust;		/* thrust induced pitch */

	short	MYailerons;		/* aileron effectiveness */
	short	MYdy;			/* roll damping */
	short	MYvx;			/* dihedral effect */

	short	MZrudder;		/* rudder effectiveness */
	short	MZdz;			/* yaw damping */
	short	MZvx;			/* weathercock stability */
	short	MZailerons;		/* ailerons induced yaw */
	short	MZdy;			/* roll induced yaw */

	short	hudtype;		/* HUD_F16 etc. */

	short	opt[10];		/* options */

	PID	PIDthrottle;
	PID	PIDpitch;
	PID	PIDroll;
};

extern int	FAR dynamics_input (OBJECT *p, int interval);
extern int	FAR on_runway (OBJECT *p);
extern void	FAR CCnote (OBJECT *p, char *note);
extern void	FAR CCland (OBJECT *p);
extern void	FAR CCfly  (OBJECT *p);
extern int	FAR BulletSpeed (OBJECT *p, VECT V);
extern int	FAR BombSpeed (OBJECT *p, VECT V);
extern int	FAR BombIP (LVECT R, VECT V, long tz, LVECT IP);
extern void	FAR supply (OBJECT *p);

#define EEP(p)	EE(p)->parms
#define EX	EE(p)
#define EP	EEP(p)

