/* --------------------------------- fa18.prm ------------------------------- */

/*
 * This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
 *
 */

/* plane parameters: FA18
*/

#include "parms.h"

400,		/* area */
38,		/* span */
21830,		/* weight */
21200/10,	/* thrust (mil) */
85,		/* sfc (mil) */
32000/10,	/* thrust (ab) */
217,		/* sfc (ab) */
115,		/* liftoff */
9,		/* max lift */
-6,		/* min lift */
30*VD90/90,	/* pitch */
180*VD90/90,	/* roll */
50,		/* flaps */
60,		/* spoilers */
11000,		/* fuel */
90,		/* efficiency */
10,		/* height */
-D90/90,	/* onground pitch */
50000,		/* ceiling */
578,		/* stores: M61   */
16,		/* stores: MK82  */
0,		/* stores: spare */
0,		/* stores: spare */
0,		/* stores: spare */

FCON(0.70),	/* friction with brakes applied */
FCON(0.02),	/* friction when freewheeling */
DEG2ANG(0),	/* Wing rigging angle vs. plane */
DEG2ANG(-3),	/* Tail rigging angle vs. wing */
FCON(0.1),	/* tail volume */
FCON(5.0/30.0),	/* flaps effectiveness: alphaDEG/flapsDEG */
DEG2ANG(-2),	/* alpha where Cl=0 */
FCON(1.5),	/* max Cl for wing foil */
FCON(0.05),	/* parasitic drag: profile */
FCON(0.50),	/* parasitic drag: speed brakes */
FCON(0.10),	/* parasitic drag: gear */
FCON(0.002),	/* parasitic drag: each MK82 */

FCON(40.0/57.0), /* max elevators */
FCON(30.0/57.0), /* max ailerons */

FCON(-0.01),	/* rudder sideforce */
FCON(-1.00),	/* vx damping */

FCON( 0.05),	/* elevators effectiveness */
FCON(-0.40),	/* pitch damping */
FCON(-0.10*0),	/* stabilizer induced pitch */
FCON( 0.01*0),	/* lift induced pitch */
FCON( 0.01*0),	/* drag induced pitch */
FCON( 0.01*0),	/* thrust induced pitch */

FCON(-0.40),	/* ailerons effectiveness */
FCON(-1.00),	/* roll damping */
FCON(-0.10*0),	/* dihedral effect */

FCON(-0.03),	/* rudder effectiveness */
FCON(-0.50),	/* yaw damping */
FCON( 0.10),	/* weathercock stability */
FCON(-0.01),	/* ailerons induced yaw */
FCON( 0.00),	/* roll induced yaw */

HUD_FA18,/* HUD type */

/*
 * these 10 options are for future use.
*/

	MODEL_XPLANE,	/* flight dynamics: 0=basic 1=classic 2=xperimental */
	0,		/* response */
	0,		/* 0=log, 1=linear control of pointer */
	0,		/* turn speed (classic), lift (basic) */
	0,		/* 1=allow stall */
	0,		/* reserved */
	0,		/* reserved */
	0,		/* reserved */
	0,		/* reserved */
	0,		/* reserved */
/*
 * these are the three PID parameter sets
 *
 *	P,	Iband, Ki,	Dband, Kd,	factor,		limit
*/
	400,	20*VONE, 10,	50*VONE, 400,	1000*VONE,	20,
	400,	D90/30, 1,	D90/1, 400,	100*D90/50,	50,
	300,	D90/9, 10,	D90/1, 300,	-100*D90/50,	100
