/* --------------------------------- parms.h -------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Common header for plane parm modules.
*/

#define	VONE		16
#define	D180		32768
#define	D90		16384
#define	VD90		(D90/VONE)
#define	VD180		(VD90*2)
#define	VD360		(VD90*4)
#define	DEG2ANG(x)	((x)*D90/90)

#define	FONE		16384
#define	FCON(c)		(FONE*(c))

#define	HUD_TYPE	256
#define	HUD_CLASSIC	(0*HUD_TYPE)
#define	HUD_FA18	(1*HUD_TYPE)
#define	HUD_F16		(2*HUD_TYPE)
#define	HUD_F15		(3*HUD_TYPE)
#define	HUD_FLIR	(4*HUD_TYPE)

#define MODEL_BASIC	0
#define MODEL_CLASSIC	1
#define MODEL_XPLANE	2

