/* --------------------------------- om61.c --------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* object: M61 bullet. Also bullet related routines.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "fly.h"
#include "plane.h"

extern int FAR
BulletSpeed (OBJECT *p, VECT V)
{
	int	bspeed;

	bspeed = p->speed;			/* rel bullet speed */
	if (bspeed > VMAX-BULLETV)
		bspeed = VMAX - bspeed;
	else
		bspeed = BULLETV;
	Vscale (V, p->T[Y], bspeed);		/* rel bullet vector */
	Vinc (V, p->V);				/* abs bullet vector */
	bspeed = ihypot3d (V);			/* abs bullet speed */
	return (bspeed);
}

static SHAPE shape_m61 = {
	0,
	0,
	SH_G|SH_HIT,
	100L,		/* weight */
	0		/* drag */
};

static int FAR
init_m61 (BODY *b)
{
	if (shape_read (&shape_m61, "m61.vxx"))
		return (1);
	return (0);
}

static void FAR
term_m61 (BODY *b)
{
	shape_free (shape_m61.v);
}

static int FAR
create_m61 (OBJECT *p)
{
	ANGLE	errmag, errdir;
	int	v;

	if (!st.owner)
		return (1);

	p->color = st.white;
	p->time = 3*TIMEPSEC;
	p->owner = st.owner;
	p->ownerid = st.owner->id;
	p->damage = 1;
	p->damaging = 1;
	p->flags |= F_DONE;
	if (st.owner->flags & F_IMPORTED) {
		p->flags |= F_IMPORTED;
		p->rplayer = st.owner->rplayer;
	}

	LVcopy (p->R, st.owner->R);
	Vcopy (p->a, st.owner->a);

	errmag = rand() % (BULLETSCATTER+1);
	errmag = muldiv (errmag, errmag, BULLETSCATTER);
	errdir = (rand()%D90)*4;
	p->a[X] += fmul (errmag, COS(errdir));
	p->a[Z] += fmul (errmag, SIN(errdir));
	Mobj (p);

	if (st.owner->speed > VMAX - BULLETV)
		v = VMAX - st.owner->speed;
	else
		v = BULLETV;
	Vscale (p->V, p->T[Y], v);
	Vinc (p->V, st.owner->V);
	v = rand () % st.interval;
	p->R[X] += muldiv (p->V[X], v, 1000);
	p->R[Y] += muldiv (p->V[Y], v, 1000);
	p->R[Z] += muldiv (p->V[Z], v, 1000);
	p->speed = ihypot3d (p->V);

	if (st.quiet)
		Snd->Beep (1000, 10);

	if (st.owner == CC)
		++st.nbullets;
	return (0);
}

BODY BoM61 = {
	0,
	0,
	"M61",
	&shape_m61,
	init_m61,
	term_m61,
	create_m61,
	body_delete,
	body_dynamics,
	body_hit
};

