/* --------------------------------- obox.c --------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* object O_BOX: only one side edge makes it more animated.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "fly.h"

static SHAPE shape_box = {
	0,
	0,
	SH_G|SH_BEHIT,
	50*1000L,	/* weight */
	0		/* drag */
};

static int FAR
init_box (BODY *b)
{
	if (shape_read (&shape_box, "box.vxx"))
		return (1);
	return (0);
}

static void FAR
term_box (BODY *b)
{
	shape_free (shape_box.v);
}

static int FAR
create_box (OBJECT *p)
{
	int	i;

	p->da[Z] = VD360/5;
	Mident (p->T);
	if ((i = CS->device->colors) > 16)
		i = 16;
	p->color = rand () % (i-1) + 1;
	p->time = 5*60*TIMEPSEC;
	p->flags |= F_VISIBLE;
	p->damage = 3;
	p->damaging = 1;
	p->R[Z] = (rand()%3000 + 1000)*(long)VONE;
	do {
		p->V[Y] = rand()%(400*VONE) - 200*VONE;
		p->V[X] = rand()%(400*VONE) - 200*VONE;
		p->speed = ihypot3d (p->V);
	} while (p->speed < 120*VONE);
	return (0);
}

static void FAR
dynamics_box (OBJECT *p, int interval)
{
	if (p->flags & F_HIT) {
		body_dynamics (p, interval);
		return;
	}

	if (p->V[Z] > -250*VONE)
		p->V[Z] -= TADJ (5*GACC);

	if (p->R[Z] < 0) {
		p->R[Z] = 0;
		p->V[Z] = -p->V[Z];
		p->V[Z] -= p->V[Z]/16;
	}

	if (p->R[X] > 5000L*VONE) {
		p->V[X] = -p->V[X];
		p->R[X] = 5000L*VONE;
	} else if (p->R[X] < -5000L*VONE) {
		p->V[X] = -p->V[X];
		p->R[X] = -5000L*VONE;
	}

	if (p->R[Y] > 5000L*VONE) {
		p->V[Y] = -p->V[Y];
		p->R[Y] = 5000L*VONE;
	} else if (p->R[Y] < -5000L*VONE) {
		p->V[Y] = -p->V[Y];
		p->R[Y] = -5000L*VONE;
	}
	p->speed = ihypot3d (p->V);

	p->a[Z] += TADJ(p->da[Z])*VONE;
	Mident (p->T);
	Mrotz (p->T, p->a[Z]);

	return;
}

BODY BoBox = {
	0,
	0,
	"BOX",
	&shape_box,
	init_box,
	term_box,
	create_box,
	body_delete,
	dynamics_box,
	body_hit
};
