/* --------------------------------- pcdos.c -------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* general system-specific stuff for PCDOS.
*/

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <dos.h>

#ifndef _LOADDS_
#define _LOADDS_
#endif

#define CDECL _cdecl

#include "fly.h"

/* pcdos/console.c */
extern int	FAR pcdos_push (int c);


#define INT_DIV0	0x0000

static void (CDECL interrupt FAR * old_div0)() = 0;


void FAR CDECL _LOADDS_
sig_int (int sig)
{
	signal (SIGINT, sig_int);

	pcdos_push ((int)(Uchar)('c' - 'a' + 1));
}

void FAR CDECL _LOADDS_
sig_shutdown (int sig)
{
#ifdef SIGBREAK
	signal (SIGBREAK, SIG_IGN);
#endif
#ifdef SIGTERM
	signal (SIGTERM,  SIG_IGN);
#endif

	MsgEPrintf (-10, "Shutdown requested");

	st.flags1 |= SF_TERM;
}

#ifdef SIGABRT
void FAR CDECL _LOADDS_
sig_abort (int sig)
{
	MsgEPrintf (-10, "Abort requested");
	die ();
}
#endif

static void FAR CDECL interrupt
div0 (int dummy)
{
	Uint		*p;
	int		i, j;
	Uchar		FAR * FAR *q, FAR *qq;
	extern		FAR main ();
	Uchar		FAR *m = main;
#if defined(USE_ASM) && defined(MSDOS)
	Uchar		FAR *md = muldiva;
#endif

	LogPrintf ("divide overflow\n");

	p = &dummy;
	LogPrintf ("\n");
	LogPrintf ("stack at %p:", p);
	for (j = 0, i = -16; i < 128; ++i, ++j) {
		if (!(j%8))
			LogPrintf ("\n%04x ", i);
		else if (!(j%4))
			LogPrintf (" ");
		LogPrintf (" %04x", p[i]);
	}
	LogPrintf ("\n");

	q = (Uchar FAR * FAR *)(p + 10);
	qq = *q;

	LogPrintf ("\n");
	LogPrintf ("main  at %p\n", m);
	LogPrintf ("fault at %p (relative %04x:%04x)",
		qq, FP_SEG(qq) - FP_SEG(m), FP_OFF(qq));
#if defined(USE_ASM) && defined(MSDOS)
	if (qq > md && qq <= md+8) {
		LogPrintf ("\nfault at muldiv(), tracing back\n");
		q = (Uchar FAR * FAR *)(p + 13);
		qq = *q;
		LogPrintf ("fault at %p (relative %04x:%04x)",
			qq, FP_SEG(qq) - FP_SEG(m), FP_OFF(qq));
	}
#endif
	for (j = 0, i = -64; i < 64; ++i, ++j) {
		if (!(j%16))
			LogPrintf ("\n%p ", qq+i);
		else if (!(j%4))
			LogPrintf (" ");
		LogPrintf ("%02x", qq[i]);
	}
	LogPrintf ("\n");

	die ();
}

static int FAR
init (void)
{
	old_div0 = _dos_getvect (INT_DIV0);
	_dos_setvect (INT_DIV0, div0);

	signal (SIGINT,   sig_int);

#ifdef SIGBREAK
	signal (SIGBREAK, sig_shutdown);
#endif
#ifdef SIGTERM
	signal (SIGTERM,  sig_shutdown);
#endif

#ifdef SIGABRT
	signal (SIGABRT,  sig_abort);
#endif

	return (0);
}

static void FAR
term (void)
{
	signal (SIGINT,   SIG_DFL);

#ifdef SIGBREAK
	signal (SIGBREAK, SIG_DFL);
#endif
#ifdef SIGTERM
	signal (SIGTERM,  SIG_DFL);
#endif

#ifdef SIGABRT
	signal (SIGABRT,  SIG_DFL);
#endif
	_dos_setvect (INT_DIV0, old_div0);
}

static void FAR
poll (void)
{}

static short FAR
disable (void)
{
	short	flags;

	_asm {
		pushf
		pop	flags
		cli
	}
	return (flags);
}

static void FAR
enable (short flags)
{
	_asm {
		push	flags
		popf
	}
}

static void FAR
shell (void)
{
	system ("command");
}

extern struct SysDriver SysDriver = {
	"PCDOS",
	0,
	init,
	term,
	poll,
	disable,
	enable,
	shell
};
