.\" This is part of the flight simulator 'Fly8'.
.\" Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
.\"
.\" Use: sed '/^$/d' <fly8.mm | groff -T<device> -rO1.25i -mm >fly8.<device>
.\"	then print it to an appropriate printer.
.\"
.\" Justify paragraphs and set style
.SA 1
.nr Pt 0
.\" Start level 1 headings on a new page.
.nr Ej 1
.\" Set fonts (3 = bold, 2 = italic) and size (points) for each heading level
.ds HF 3 3 2 2 2 2 2
.ds HP 14 12 12 12 12 12 12
.\" These are groff mm macro registers - ignored if not using groff
.nr Hps1 2v
.nr Hps2 3v
.\" Set fonts (3 = bold, 2 = italic) and size (points) for each heading level
.ds HF 3 3 2 2 2 2 2
.ds HP 18 14 12 12 12 12 12
.if \n[.g] \{\
.	\" Set ToC title
.	ds Licon "\s18Table of Contents\s0
\}
.\" Force "break follows heading" for all levels
.nr Hb 8
.\" Generate ToC to level 7
.nr Cl 7
.PH "''\fIPage %\fP''
.PF "'\fIVersion 1.00\fP'\fIFLY8\fP'\fIFlight Simulator\fP'
.ce 100
.ps 18
.vs 20
.sp
FLY8
.br
Flight Simulator
.ps 12
.vs 14
.I
.sp
Eyal Lebedinsky
.ps 10
.vs 12
.R
.sp
eyal@ise.canberra.edu.au
.ce 0
.sp 3
.H 1 "Introduction"
.P

This program is a flight simulator. It puts more emphasis on the
dynamics than on the cosmetics: just wire-frame. It can run on any
machine but a 386DX is the minimum for any decent performance. A fast
video controller is a boon as the program, when running on a
386DX/40Mhz, spends 70-80% of its time pushing pixels. On non-intel
machines you can try and see if it is fast enough...

.P

The program was written for fun. I borrowed ideas from everywhere and
hope to hear some more. The basic design is based on a program I wrote
more than 20 years ago at uni (the Technion). I had an excellent coach
(Danny Cohen) and I still have fond memories of those times. But now my
computer has more than 24Kbytes of memory! so Fly8 is written in C (Fly8
was the name of the last version of the original program dated
12-JAN-1974, it was written in PDP15 assembly - macro15 - for a VT15
graphics processor).

.P

On the PC the basic screen drawing uses the standard Microsoft graphics
library. It is OK but not very fast; the main advantage is that it will
support most video adapters. The Tseng4k drawing was built from the
routines from DJGPP with much personal additions. The flight dynamics
was influenced by an SGI program I saw and ACM. The timer routines come
from a microsoft journal article, the user-input routine (notice how you
can use arrow keys etc? use up-arrow to retrieve history.. I will
document it one day) comes from DDJ (or was it CUJ? author name is Bob
Bybee). Well, I avoid re-inventing wheels unless it is fun. The program
compiles with Microsoft C, Borland C, gcc on a friends Amiga, Sun and
Linux and I hope on other platforms; it is written to be portable. It
runs under MSDOS, MSWindows, Amiga and unix/X-Windows.

.P

What? what? WHAT? you want to see some action? OK. just skip to the next
chapter then come back.

.P

The full set of commands is detailed in the 'commands' chapter. Here we
will look at the program areas in general.

.P

There are two rather distinct kinds of commands that one uses: commands
that drive (fly) the game and commands that configure, set options and
so on which are used with less urgency. It was attempted to get the
important commands into the keyboard (a one keystroke command) while the
others go into the main menu system (accessed with the Esc key). Some of
the urgent commands may bring up a menu which you may ignore if you know
the keystokes.

.P

The urgent commands will control the vehicle flight and the other
subsystems (radar, HUD, HDD, weapons etc.). You will notice early that
the program lacks the traditional instrument panel: it is intended to be
driven from the HUD and other digital displays.

.P

The vehicle is also driven by a pointing device (a mouse or, preferably,
a joystick). It will run off the keypad when you have no such device.
The pointer is used only for steering control although the buttons can
be mapped to auxiliary functions (by default both 'fire').

.P

The display area is typicaly divided into the main view and a number of
secondary Head Down Displays (HDD). The design has a dozen or so on
board instruments that generate visual data; you select which ones
should be displayed on which HDD. The main view is what you see through
the cockpit. The HUD can be overlaid onto this view (as is the case with
a real plane). Other data may also be shown here for convenience.

.P

One other instrument is designated as an alternate main view (use the
\'v' command to see it). The 'windows' menu handles the screen
configuration.

.P

The program generates various messages as it goes along, these will
appear at the bottom of the main view and stack up. Each message has a
time-out for deletion but you can use 'c' to clear the lot. When the
program needs user input it will open a prompt line at the very bottom
of the main view (in magenta color) where your data will show. You can
use the normal editing keys while entering data here - previous entries
are accessible with the up/down arrows. See 'input line editing' later.

.P

You may find some of the commands/options strange (if not outright
insane); this will be related to my taste or (mostly) to much history
and quick fixing that did not completely settle yet. I have looked at
other programs (like F3, JF2, ACM and SGI f.s.) but this was after the
first version of this program was finished, so some good ideas missed
the bus this time. In the future I hope to polish the user interface
(especialy after other people get to use it and express an opinion).

.P

Being as the program is still evolving you will find some areas less
complete than others. I hope that there is enough of it to make it
useful. I expect to see contributions (of ideas and code) from other
people; I will continue to develop the program (at least for a while)
and would like to see it take it's own path in life [heavy stuff :-)].

.H 1 "Quick start"
.P

In this chapter the symbol '@' is used to denote the Enter key.

With the program installed, type

.P
.ti 5

\fCfly -z5\fP

.P

This starts a demo run and is useful to see if all is OK and also great
as a screen blanker.

.P

If the fly.ini options are correct then your plane will take off and
start looking for action. Some messages are displayed during startup -
these will disappear after a short while. The screen will show a simple
view of the runway, a ground grid (in gray) and an overlaid HUD.

.P

If there is no picture, try hitting 'Enter'. Then try 'Esc' 'x' 'y'. If
no luck then reboot (I guess). Now check the fly.log file which may have
an error message in it. It was found that with some accelerator cards
the program hangs (don't know why, I use the MicroSoft C graphics
library and most advanced cards should emulate VGA). Try installing the
correct video VESA bios.

.P

DO NOT RUN THIS PROGRAM IN A DOS WINDOW OF MSWindows OR OS/2! Use the
MSWindows version for MSWindows.

.P

The scene will include you and 5 other planes (drones). Your auto-pilot
will track and shoot the drones. As they are shot down, new ones
take off. To take control back from the
autopilot hit Shift-C. Now use the joystick to fly the plane. One button
shoots while the other un-locks the radar.
When the target is in the correct position the autopilot will shoot (unless
you tell it not to with 'k'). The idea is to fly your plane so that the
target is inside the aiming reticle (the small circle) and then shoot. A
SHOOT cue will flash when your aim is correct.

.P

This how you fly the plane: moving the joystick sideways will start
the plane rolling. The further you move the stick the faster the roll. Once
you center the stick the roll will stop. In order to fly level you need to
roll either way untill you are level and then center the stick.

.P

Moving the stick away from you will puch the nose of the plane DOWN, pulling
the stick back will pull the nose up. When the stick is centered the plane
will maintain it's climb angle.

.P

So far we roll and pitch but we did not yet turn. In order to turn one needs
to use both controls. To turn right, first roll to the right, then pull the
plane 'up'; at this point 'up' is actualy 'right'. Remember that the joystick
controls the plane relative to itself (the pilot if you wish) and NOT relative
to the ground. Once you turn in the desired dirction you can roll left to
resume level flight in the new heading.

.P

Because the plane has weight, if you roll and start turning the plane will
also start falling down (the wings no longer support the full weight of the
plane) so a realistic turn will call for a moderate roll and not a full
90 degrees. The harder you will pull the stick, the faster you will turn
and the larger roll you should execute to maintain level during the turn.

.P

You probably do not want more instructions at this 'quick start' section,
not to mention that I never flown a plane and am not qualified for much
in the way of flight instruction. Any volunteers for writing a flight
manual chapter.

.P

Knowing how to fly the plane is not enough, you also need to know how to
partcipate in the game (fight). Actualy, in order to start winning you
will need to be able to fly without thinking, you will need your logic
powers to control your situation and plan your moves.

Your strategy is to avoid being hit and try and kill all enemy planes. There
it is, as simple as can be. I wonder why people fill books with chat about
Basic Flight and Air Combat Maneuvering :-)

.P

Now a quick look at controlling other equipment. For takeoff, release the
wheel brakes (b) and set full throttle (1) or even light the afterburner
(a few hits on the '.' key). You may want to set the flaps (a few ']', then
reset with '[') but it is not necessary. At a speed of 150-200 pull the nose
up gently (not more than 10-15 degrees) and wait for takeoff. After you
gain some high (but rather soon) retract the landing gear (g). There you are
in the air. Do not try a sharp turn too soon as you may loose altitude and
hit the ground, unless you are exoerienced with this sort of thing.

.P

To land, reduce speed and approach the runway as a steady descent. Just
before touchdown reduce the descent to the bare minimum (don't forget to
lower the landing gear (g) in time but not too early). Once on the ground
engage the speed-brakes (+) and reverse (just hit 3 until you have -100 power
showing). When your speed is low enough engage the wheel brakes (b) and
towards the end idle your engines (0) and release the speed brakes (+). Once
you are stationary on the ground with the engine idle your fuel will start
to be replaced and finally your wepons will be replaced and your damage
will be reset.


.P

When flying, use 'r' to switch the radar on and off, use 'w' to select your
weapon and use 'v' to switch of a map view of the world (with you at the
center) and back to normal view.

.P

This should do you for starters.

.P

While we are here, do 'Esc' 'i'. Some numbers will show
at the top of the screen. The first is the total time (in milliseconds)
for one frame, the second is the video-drawing time. If the total time
goes over 100 often then you should buy a faster machine (actually a
faster video card may be a better investment). If it stays under 60-70
then all is fine.

.P

On MSDOS, if you have a TsengLab ET4000 based card then try running

.P
.ti 5

\fCfly -dgrt4k -m640x480x256 -z5\fP

.P

and if it works you will notice the speedup. Try higher resolutions (on
my 1Meg card I use 800x600x256 which runs with double buffering
(to eliminate flicker). The standard Microsoft library does not do double
buffering above 640x350x16 even in C7; don't know why - the memory is
there. You may wish to edit the file 'fly.ini' with your preferred setup
so that you will not need to specify it in the future.

.br
.sp
To exit hit 'Esc' 'x' and 'y'.

.H 1 "Installation"
.P

On most environments all you need to do is unpack the distribution
archive into your prefered directory and you are set. Refer to the README
file for specific instructions.

.H 1 "Commands Reference"
.P

Fly8 commands are one keystroke each but some expect some data or
options to follow, which may bring up a prompt or a menu.

.P

Some commands are used only when the 'keypad' is selected as the
pointing device for flying. Otherwise the commands are grouped here by
their physical location and organized alphabetically.

.P

The program usually runs with the NumLock engaged which means that the
keypad keys duplicate the digits 0 through 9 and the period '.'.

.P

There is no current facility to redefine the usage of the keys but the
keyboard macros can be of use here. See under F7/F8.

.H 2 "Alphabetic Keys"
.P

Most commands toggle their function on/off, some cycle through modes.

.VL 10 5
.LI A

select aiming reticle mode. (cycles)  [debug] This is used for
experimenting with various LCOS formulae and will be gone once it
settles down. At this point the calculations are based on linear
motions, it should be modified to follow an arc instead. The setting is
shown as 'Mn' in the 'modes' screen in the 'radar' part.

.VL 5
.LI 0
no acceleration correction
.LI 1
0.5 second correction
.LI 2
1.0 second correction
.LI 3
t/2 seconds correction (t=time to hit) (default)
.LI 4
t*t/2 seconds correction
.LE

.LI b

Wheel brakes (toggle). Can be applied at any time but only effective when
on the ground. In reality these should not be operated at high speed
(use speed brakes and reverse thrust for initial slow down).

.LI c

Clear text area By now there is no text area anymore. The only messages
expected are the \'paused' and 'resumed' which may litter the screen.
This command also removes all outstanding messages.

.LI C

Chase the locked target (toggle) This is the auto-pilot mode. If there
is no target (or the radar is turned off) then the plane will wander
around the airport perimeter. If there are ground targets then these
will be chased and the plane will crash! This mode is activated by the
command line option '-z'. If the kill-mode is enabled ('k') then the
auto-pilot will fire at the target.

.LI D

Descend the parachute. After you eject it may take a while to get to the
ground. You can pass the time by looking around (use the arrow and F5/F6
zoom keys), or you can jump to the landing phase with this command. If
you land before your plane crashes then you will have to wait (a WAIT
notice will be shown).

.LI E

Eject. If your plane is not dead, your ejecting will send it crashing.

.LI f

Radar target acquisition mode select (cycle). Controls the manner by
which the radar selects a target as explained in the relevant chapter.

.LI g

Landing gear up/down (toggle) Don't raise the gear while on the ground.
If you do so while at the base of the runway then you will go into a
plane-crash loop which will abort the program!

.LI h

Help (also ?)

.LI i

Intelligence: identify all visible targets (toggle) This is what makes
this program better than the real thing... in this mode all visible
targets are identified even when outside of the HUD area. You need to
have HUD data mode enabled to get info about the targets.

.LI j

Radar sees only real pilots (ignores drones) (toggle) The program can
generate drones for target practice. If you want the radar to ignore
these and only show (and select) real planes then use this command.
There are other pilots only when you are networked.

.LI k

Kill- auto shoot when ready (toggle). When a target is in range and in
correct position the auto-pilot will flash a SHOOT cue. In this mode the
selected weapon will be fired at this point. The  radar must be active
with a locked target (you should see a piper).

.LI l

Lock target (toggle) The radar can operate in two modes, either it
continuously selects a target according to the designated target
acquisition mode or it stays locked on the current one. In the locked
mode, the first selected target will be locked on and no more searching
will be done. When not locked the target designator will be shown as a
broken box. You can use the un-lock command (usually attached to one of
the buttons and to the space-bar) to release the current target
and acquire a new one.

.LI m

Show general program status. (toggle) This replaces the numerous mode
indicators that planes have.

.LI o

Observer select. See the world from another object's point of view. Also
useful for just a list of the objects. The list of current objects is
presented. Hit Enter to abort or select an object. The selection 'c'
will return you to your controlled plane. 'l' will select your target as
the view object (if there is a target). In the list, piloted planes have
a 'c' and your target has an 'l'. Note that you cannot use this command
if networking is active. Also as objects come and go, by the time you
select an object (by a sequence number in the list) it may have moved up
the list - you end up with the wrong object. The command is not
considered important enough to make it any more robust.

.LI O

As 'o' but also shows minor objects.

.LI p

Pause. Will not work when net is active (toggle). The "Pause" or
"Resumed" message tells you what the new state is. As the prompt is in
text mode, in some implementation it will not clear, so use 'c'.

.LI q

Quiet (sound) mode. (cycle) Sets the sounds level to one of the
following. Note that the independent 'aural alarm' option can be used to
turn the nagging alarms on/off.

.VL 5

.LI 0

no sound.

.LI 1

only shoot/hit/alarms sounds (default).

.LI 2

all sounds and effects. For now the only effect is the engine noise.

.LE

.LI r

Activate radar (toggle)

.LI S

resupply plane: full stores and fuel, reset damage.

.LI u

Hud configuration. see 'hud commands' later. Identical to the main menu
\'hud' function.

.LI v

Select normal/alternate view (toggle). Will bring the designated
alternate instrument into the main view. The alternate view is defined
through the window configuration menu. Note the view name at the top right
corner of the screen.

.LI w

Select weapon (cycle).

.LI W

Remove all weapon stores. The plane manoeuvres better this way. You can
still use the weapons, the counters will just go negative.

.LI x

Calibrate pointer. Mainly for joystick. center it and then hit x.

.H 2 "Symbol Keys"

.P

These are the rest of the keys on the main keyboard. For clarity each
key's name is spelled out. If it is allocated then the function follows.


.VL 25 5

.LI "\\\\  [back del]"

.LI "\\\\  [escape]"

invoke the menu system

.LI "\\\\  [space]"

release radar lock

.LI "` [grave accent]"

.LI "- [hyphen]"

see keypad '-'

.LI "= [equals sign]"

.LI "\\\\\\\\ [back slash]"

.LI "[ [l-bracket]"

less flaps

.LI "] [r-bracket]"

more flaps

.LI "; [semicolon]"

.LI "' [quote]"

.LI ", [comma]"

.LI ". [period]"

see keypad '.'

.LI "/ [slash]"

see keypad '/'

.LI "~ [tilde]"

.LI "! [bang]"

shell to system. May not restore isome environment parameters and pallette.
Use 'exit' to resume. Now implemented on windowed enviroments.

.LI "@ [at symbol]"

.LI "# [hash]"

.LI "$ [dollar]"

.LI "% [percent]"

.LI "^ [caret]"

.LI "& [ampersand]"

.LI "* [asterisk]"

see keypad '*'

.LI "( [l-paren]"

.LI ") [r-paren]"

.LI "_ [underdash]"

.LI "+ [plus]"

see keypad '+'

.LI "| [pipe]"

.LI "{ [l-brace]"

less spoilers

.LI "} [r-brace]"

more spoilers

.LI ": [colon]"

.LI "\N'34' [double quote]"

.LI "< [less than]"

.LI "> [greater than]"

.LI "? [question mark]"

help

.LE

.H 2 "Keypad"

.P

The keypad is a collection of keys that replicate the main keyboard.
These are described as three groups by function.

.P

The following keys surround the numerical keypad and are not affected by
the Shift key.

.VL 20 5

.LI -

view right (+45 degrees)

.LI *

view ahead

.LI /

view left (-45 degrees)

.LI +

air brakes (toggle). Note that the air-brake takes time to deploy, it's
status is shown on the control panel in percent of full extension.

.LI (Enter)

unallocated

.LE

.P

The rest of these keys must have NumLock on.

.P

These first four keys respond only if the keypad is your pointing device.

.VL 20 5

.LI "8 (up)"

pitch (pull nose) up

.LI "2 (down)"

pitch (push nose) down

.LI "6 (right)"

roll right

.LI "4 (left)"

roll left

.LE

.P

The following commands extend all pointing devices capabilities:

.VL 20 5

.LI "5 (center)"

center ailerons and elevetors, like centering the joystick. Useful when using
a mouse (or trackball): will move the reference point to where the mouse is
at this moment.

.LI "7 (Home)"

stop rolling. Levels the plane. For quiche eaters.

.LI "9 (PdUp)"

more (+5%) power

.LI "3 (PdDn)"

less (-5%) power

.LI "1 (End)"

mil (dry) (100%) power

.LI "0 (Ins)"

zero (0%) power

.LI ". (Del)"

after burner up (+1 unit which is 20% of full scale)

.LE

.H 2 "Special keys"

.P

These keys are a group of six on most keyboard but can also be
duplicated using the Shift key and a numerical keypad key.

.VL 20 5

.LI PageUp

level (heading 0, pitch 0, roll 0)

.LI PageDn

reset coordinates to zero (back to base)

.LI Home

unallocated

.LI End

unallocated

.LI Insert

unallocated

.LI Delete

unallocated

.LE

.H 2 "Function keys"

.P

The function keys are normally used in plain mode (no Shift, Alt or
Ctrl). When the menu is on the up-front, the left column ten selections
are accessible with F1-F10 while the right column uses AltF1-AltF10.

.VL 10 5

.LI F1

shoot. Usually also mapped the mouse left button and both joystick
buttons.

.LI F2

rudder left

.LI F3

rudder center

.LI F4

rudder right

.LI F5

zoom in (more detail, narrower view, eye further from window).

.LI F6

zoom out (less detail, wider view, eye closer to window).

.LI F7

Macro/HotKey definition.

Any key can be used for a macro name (except F7/F8). If you define a
macro for a HotKey (CTRL-A thru CTRL-Z) then it can be played back with
one keystroke. Other keys are played using the F8 key.

If you use a Macro during recording then the Macro will be recorded. If
you later re-define this Macro then it will affect any other Macros that
uses it.

During macro expansion there is a limit of 16 levels of nesting.

There is no capability for Macros definition editing.

.VL 20

.LI "define"

F7<macro-key><keystrokes>F7

.br

If the key is already defined then you are warned of the re-definition.
You may abort at any stage (F8F8) and the original definition will
remain.

If you hit F8 during recording then you are prompted by
Abort/Cont/Quote? to which you may respond by F8 (abort the recording),
F7 (ignore the F8 and continue recording) or any other key (the key will
be recorded with the F8 expecting it to be another macro).

.LI "delete"

F7<macro-key>F7

.br

It is not possible to record a null macro.

.LE

.LI F8 "Macro play"

F8<macro-key>

.VL 20

.LI "HotKey play"

<HotKey>

.br

Hot keys are from CTRL-a through CTRL-z.


.LE

.LI F9

unallocated

.LI F10

unallocated

.LI F11

unallocated

.LI F12

unallocated
.LE

.H 2 "ALT keys"

.P

ALT-Arrows: see below.

.P

The other keys are unallocated.

.H 2 "CTRL keys"

.P

CTRL-Arrows: see below.

.P

CTRL-A thru CTRL-Z are reserved for user defined HotKeys.

.P

The other keys are unallocated.

.H 2 "Arrow keys"

.VL 20 5

.LI up

turn gaze (head) down

.br
All turns by 5 degrees

.LI down

turn gaze (head) up

.LI left

turn gaze (head) left

.LI right

turn gaze (head) right

.br

use '*' to restore normal front view.

.LI CTLup

taller window.

.LI CTLdown

shorter window.

.LI CTLright

wider window.

.LI CTLleft

narrower window.

.LI ALTup

debug (varies).

.LI ALTdown

debug (varies).

.LI ALTright

debug (varies).

.LI ALTleft

debug (varies).

.LE

.H 1 "Menus"

.P

A menu has a list of options, each associated with a key and a function.
To select a function use the Up/Dn arrows to highlight it and then
Enter, or directly press the corresponding key. When on the up-front,
the associated letters are NOT shown but are recognized; use the F-keys
to select left column functions and AltF-keys for the right column. See
under HDD later.

.P

Menus can be nested, in which case the previous selections are listed
first (in a staggered fasion and highlighted) followed by the current
menu. The selected option is highlighted (white) while the others are
displayed in gray.

.P

The Esc key brings up the top menu but later is used to abort a menu.
During menu navigation use these keys:

.VL 20 5

.LI Esc

aborts the menu

.LI Enter

accept the current selection option

.LI UpArrow

select previous option

.LI DnArrow

select next option

.LI other

select the corresponding option

.LE

.P

If a command is invalid (top/bottom of list or undefined option) then a
beep is emited and the keystroke is ignored.

.P

The menu system is changing rapidly so the following may be incomplete.

.P

Some other commands may pop up a menu, in which case it behaves in a
similar way.

If you have the up-front instrument active then the menus will appear on
it rather than on the main menu. This is a stupid attempt to make your
interaction look similar to what happens in a modern fighter. It is
often the case that the pilot has a panel which can display about 10
alpha-numeric words in bright white (daylight readable). These will
usually use special LEDs and a more elaborate font than the 7-seg digits
(9 segment?). There are pushbuttons beside these words. The words are
arranged in two columns, each with 5 words, with 5 buttons on the right
and 5 on the left. As you press a button new information is displayed.
Other planes use a real CRT but still have the 5-buttons arrangement
(mostly on all four sides, totaling 20).

In Fly8 the up-front device has two columns of words, each column can
show 10 words, each word can be 10 characters long. There are 10 buttons
on the left (F1 through F10) and 10 on the right (AltF1 through AltF10).
Use these keys to make selections. You can still use the normal command
letters (if you know them, as they are not displayed here) as well as
move about with the Up/Down keys: a small dash between the key number
and the text identifies the currently selected option.

.H 2 "Top Menu"
.VL 15 5

.LI Exit

quit the program

.br

confirm with 'y' on subsequent menu

.LI Help

toggles the help screen on/off

.LI Pointer

select pointing device

.LI Screen

screen options.

.LI Windows

set windows configuration

.LI Info

select stats info level

.LI Emit

create some random objects or remove them

.LI Hud

configure HUD

.LI Net

networking commands

.LI Options

set global program options

.LE

.H 2 "Pointers Menu"

A list of all available pointing devices is offered. Select one. All
systems have a keypad device, most have a mouse and the PC has a
joystick.

You will be asked to specify pointer options - read about it later in the
command line options section.

.H 2 "Screen Menu"
.VL 15 5


.LI Colors

set some colors.

.LI Stereo

select a stereo mode

.LI Reverse

toggle reverse-stereo mode (swap Left and Right images)

.LI Paralax

set stereo inter-occular distance. Initialy set to 12.

.LI "Dbl Buff"

set buffering mode to double/single. A message is posted on the new mode.
Double buffering is not supported in all environments and in all modes,
and in some cases it may be significantly slower than single buffering.

.LI Blanker

toggle screen blanker mode. Borders and some fixed data are not shown in
blanker mode.

.LI "Load font"

This [obsolete] function will load a new text font. Text fonts are not
used anymore by the program.

.LI "Font show"

This [obsolete] function will display the current text font as 16 lines
of 16 characters each.

.LE

.H 2 "Stereo Menu"

select a mono/stereo mode:

.VL 15 5

.LI Mono

standard mono mode

.LI S'Scopic

side by side stereoscopic images

.LI RedBlue

red/blue composite (needs colored glasses)

.LI Alternate

alternating left/right images (needs shutter glasses and '-s' command
line option)

.LE

.H 2 "Colors Menu"

A set of colors is listed. Select one for modification.

.VL 15 5

.LI HUD

set the color of the HUD (and all other overlaid data)

.LI Sky

set the color of the sky

.LI Pilot

piloted planes (when networked) show in light red rather that the usual
white. The same color is also used for the pull-up warning grid.

.LI Ground

set the color of the ground grid

.LE

.P

You are now presented with a number of adjustment options:

.VL 15 5

.LI Brighter

intensify the color

.LI Darker

reduce color intensity

.LI New

set color to a desired RBG value

.LI Restore

restore color to original value

.LE

.H 2 "Windows Menu"

A number of window configurations are offered. This defines how the
screen is split into main and auxiliary display areas. After the
selection the screen remains active so that you can select the
\'configure' option immediately.

.VL 15 5

.LI text

a square window is used for graphics and a side bar is reserved for
text. This mode is obsolete.

.LI full

the whole screen is one window

.LI landscape

a wide main view with three windows below

.LI portrait

a square main view with a column of two windows on the right

.LI square

a square main view with a column of three square windows on the right

.LI wide

a wide main view with four square windows below

.LI configure

define which instrument is displayed in each window. The first response
will be a number shown in each window and a mode listed under it. A
prompt will ask you to select the window to be configured, then the
Configure menu will let you assign an instrument to it. This process
will be repeated until you respond with 'Enter' or 'Esc' to the prompt.

.LE

.H 2 "Configure Menu"

The plane has a number of on-board instruments, each one has a visual
representation that can be shown on one of the active displays. This
menu is used for defining which instrument is to be shown on each of the
displays. Configuring the main display (usually numbered 0) defines which
instrument will be used as the alternate view.

.VL 15 5

.LI front

this is a forward looking camera.

.LI none

designates the HDD as unassigned

.LI rear

a rear viewing camera

.LI map

a map of the area from above with you at the center and north is up.

.LI radar

as 'map' above but the plane's current heading is the 'up' direction. Gives
better situation awareness.

.LI target

a target following camera.

.LI pan

another target following camera that is less stable (more real?)

.LI gaze

a view of my plane from a fixed relative point

.LI chase

a view of my plane from a point that chases my path.

.LI follow

as 'chase' but the view is always level (never rolls).

.LI hud

this is the raw HUD display

.LI "up-front"

an alphanumeric display used for pilot interaction

.LI misc

misc digital data and warning display.

.LE

.H 2 "Info Menu"

Select the stats info level. This info is shown on the up-front HDD but
can (optionally) be overlaid on the main view.

.VL 15 5

.LI off

do not overlay 'info' on the main view

.LI on

do overlay 'info' on the main view

.LI none

no info

.LI timing

only basic timing will be shown.

.LI stats

timing and internal stats are shown, used for program testing.

.LI game

timing and basic info for a game are shown.

.sp

The second line will show (in  order):

.DL

.LI

time from start of game (in seconds).

.LI

number of targets present (both standard targets and ground targets)

.LI

number of weapons used in total

.LI

number of hits scored

.LE

.sp

The third line will show:

.DL

.LI

score (counting down!)

.LI

plane speed (meters/sec).

.LE
.LE

.P

The basic 'timing' data, which is always the first line, is a list of
millisecond durations for:

.DL

.LI

 total time of frame

.LI

graphics drawing (display list -> screen)

.LI

3D transformations (world -> display list)

.LI

objects simulation (old world -> new world)

.LI

other visual calculation (hud, text, sky etc.)

.LI

vertical sync wait (if double buffering)

.LI

total minus the rest; will include the auxiliary windows time and
network disturbance.

.LE

.H 2 "Emit Menu"

Various objects can be created with this menu. These objects are used as
targets.

.VL 15 5

.LI target

create one random target

.LI del

delete all targets

.LI gtarget

create one random ground target

.LI del

delete all ground targets

.LI box

create one random box. Boxes are cubes that hop around which can be shot
down.

.LI del

delete all boxes

.LI "del tgts"

delete all targets, ground targets and boxes.

.LI drone

create one random plane (drone)

.LI del

delete all drones. This will also set the number of automatic drones to
zero.

.LI drones

specify how many drones should be automatically maintained in the air.
Whenever one is lost another one takes off.

.LI killers

specify how many of the drones should be killers. These will be set to
Chase and Kill mode.

.LE

.H 2 "HUD Menu"

Various aspects of the HUD can be set. Each option is either set, reset
or toggled. The default is to toggle the option but the first three menu
items can be used to change this mode. This menu can be accessed from
the main menu as well as directly with the 'u' command. The following
selection appear on some of the sub-menus:

.VL 20 5

.LI "0 turn off"

turn option off

.LI "1 turn on"

turn option  on

.LI "2 toggle"

toggle option on/off

.LE

This top level menu will bring up a number of sub-menus which are
described further down this doco.

.VL 20 5

.LI type

Select HUD style. Although the styles are named after planes, each plane
actualy displays many styles depending on the mode of operation.

.LI parts

The HUD has many components. This sub-menu allows you to choose which
are included in the HUD display. Selecting a HUD type will automatically
adjust these to what is appropriate for that style.

.LI "options 1"

This (and the next) selection allows you to set some parameters which
modify the appearance of the HUD. The most often used ones are in this
sub-menu and the rest are in the next.

.LI "options 2"

See description of "options 1" above.

.LI radar

This will configure the radar symbology on the HUD.

.LI on

Turn the HUD on or off. When turned off, the radar symbols will still
show. This is a feature of the game which is not as the real thing; it
allows you to play with a very clean view. Not only will the radar stuff
still show, but the symbols will now move freely across the full screen
rather than being confined to the HUD area.

.LI ils

Will let you select the ILS beacon. In the future there should be a more
elaborate NAV facility instead.

.H 2 "HUD type Menu"

Fly8 supports a number of HUD styles. The name of the hud does not
necessarily correspond with the plane type but this is what I found on
the various videos that I saw. If anybody has more knowledge or can
provide other detail PLEASE feel free to advice me.

.VL 15 5

.LI Classic

This one I made up before seeing any real HUD. The basic data is laid
close to the edge and leaved most of the area free from obstruction. My
original aiming reticule was 8 dots in a circle but I discontinued it in
favour or the more common piper style. The numerals on the pitch ladder
do not rotate and the fast font is used. On a slow machine this hud
(especially in low detail) will perform much faster that any other.

.LI FA18

This HUD does not use tapes for the altitude and speed. The pitch ladder
is narrower than usual and slanted toward the horizon. A good feature is
the fact that the pitch ladder stays always in view: if the velocity
vector goes off the screen (easily done on the FA-18 which has no
trouble flying at high AOAs) the pitch ladder adopts (temporarily) the
waterline mark. Another feature is the closure speed which is shown
under the piper rather than on a radar ranging scale. Optionally, a
pendulum (or what do you call it?) can be displayed which shows you your
roll angle with good resolution up to 45 Degrees either way. This is a
wide angle hud - 20 degrees side to side.

.LI F16

This HUD uses simple scales (no baseline). The heading scale can be at
the top or at the bottom.

.LI F15

This HUD is probably used for air to air on other planes. The speed
scale is upside-down. The heading scale can be set to two different
positioned at the top.

.LE

.H 2 "HUD parts Menu"

The various HUD symbols can be individually selected for display.

.VL 15 5

.LI ladder

Show pitch ladder.

.LI altitude

Show altitude scale (or box).

.LI speed

Show speed scale (or box).

.LI heading

Show heading scale.

.LI pendulum

Only for the FA18 style, show the pendulum.

.LI border

Show the HUD border (in gray color).

.LI vv

Show the plane's velocity vector. A must for accurate flying.

.LI vw

This activates a mode that the FA18 uses: when the vv goes off screen, a
waterline mark will appear and the pitch ladder will be drawn around it.
This way the ladder never goes completely off screen (which can often
happen when flying at high AOAs).

.LI plus

Show a 'plus' sign at the center of the screen.

.LI pointer

Show a small (red) mark that tracks the joystick (or mouse or whatever
pointing device you  use).

.LE

.H 2 "HUD options 1 Menu"

These options modify some aspects of the HUD appearance.

.VL 15 5

.LI heading

The heading scale shows the planes heading. The numbers displayed are
in the range 000-350 in increments of 10. This option selects between
showing the full 3 digits of using an abbreviated form. The abbreviated
form will only show the top two digits (09 for 90 and 27 for 270). The
Classic HUD style will show the full number but without the leading zeros.

.LI knots

Internally all data is stored in meters. This option requests that all
numbers use knots/feet (as appropriate) instead. It is the default for
the standard HUDs.

.LI top

This will further modify the heading scale. The scale will show at the
top or at the bottom depending on this option. For the FA18 HUD style,
this option will cause a base-line to be drawn under the scale (the
scale will stay at the top regardless).

.LI fine

For some of the scales this option will show more detail. The standard
detail is to show a tick every 5 units. The fine detail will show a tick
every two units.

.LI xfine

This is a further refinement of the above 'fine' level and will show a
tick for each scale unit.

.LI big

The name is completely wrong. This option defines the style of the ticks
on the scales (for some of the HUDs only). The usual way is to have the
ticks go from the base-line to the outside. In the 'big' style the scale
will be along the edge with the ticks towards the inside.

.LI scale

This defines the number of units along the scale. This affects only the
Classic HUD. The more units, the longer the scales.

.LI area

The HUD has a fixed area (measured in field-of-view degrees). You can
alter this size. Note that although the HUD size changes when you zoom
in/out, it still keeps the same FOV. This option defines how many
degrees are from the center to the edge of the HUD (all HUDs are
square).

.LE

.H 2 "HUD options 2 Menu"

These options modify some aspects of the HUD appearance. These are the
less used options.

.VL 15 5

.LI "a alarm"

Enable aural alarms. If you hate the GLIMIT beeps etc. then use this
option to turn these alarms off.

.LI "v alarm"

This will Enable/disable the visual alarms that show on the HUD.

.LI misc

Request to show the misc HDD on the main window. This will show at the
bottom right side as digital flight data (and as some indicators at the
top left).

.LI font

Select the font for the stroke characters used on the screen

.LI fontsize

Select the stroke font size. A size of 8 means 'use the default' and all
other sizes are relative to 8. The default is calculated from the screen
resolution.

.LE

.H 2 "HUD radar Menu"

The radar symbology on the HUD is controlled with these options.

.VL 15 5

.LI corner

Radar target data can be at the bottom-left corner of the HUD or can
follow the target designator.

.LI data

Request to show target data.

.LI distance

Request to show target distance in intel mode (mainly used in the
radar/map modes).

.LI name

Request to show target type in intel mode (mainly used in the radar/map
modes).

.LI accvect

Show target acceleration vector as a hand inside the reticle piper.

.LI reticle

Show aiming reticle piper.

.LI target

Show the target designator.

.LI ross

Use Ross's method for the aiming reticle. This mode will show a small
box in front of the target where it is expected to be when a bullet hits
it. If you aim the reticle at this box and shoot then you should hit the
target.

.LI limit

Unlike real HUDs, the radar symbols can be displayed all over the screen
rather that just inside the HUD area. 'limit' will specify which way it
should be.

.LI thick

This is an experimental option to draw the radar reticle thicker.

.LE

.H 2 "Net Menu"

Some of the requests in this menu will need you to identify a player. A
numbered list of players is displayed and you should select one by
entering their number. If you Enter '*' then you will select 'all' of
them. If you give a null then you secl 'none'. If there is only one
player then it wil be selected automatically.

A message 'no net' means that the program was started withou the net
option (or possibly all net connections are inaccessible).

A message 'no player' may be displayed which means that there are no
players in the needed status (eg. you try to 'quit' but you are not
currently playing with anyone).

.VL 15 5

.LI ping

find out who else is playing. A message is broadcasted and for each
responding player a message is displayed.

.LI play

join another player's game (or all players)

.LI quit

stop playing with a player. If there are more than one players then you
will be asked to choose.

.LI message

send a message to a player (or all). You will later be notified how long
it took the message to reach each player and return a notification.

.LI accept

accept a player's request to play with you. Used in response to the
Requesting message.

.LI decline

decline a player's request to play with you. Used in response to the
Requesting message.

.LI "always accept"

automatically accept any requests to play.

.LI "always decline"

automatically decline any requests to play.

.LI "manual reply"

do not automatically respond to any requests to play.

.LE

.H 2 "Options Menu"
.VL 15 5

.LI Version

show program version and compile date/time.

.LI Smoke

set/clear smoke generation. Damaged planes and craters will smoke if the
option is enabled.

.LI Debug

show some debug info (internal, varies a lot, not much use to you)

.LI Font

show current stroke font. It is displayed if large on the center of the
screen.

.LI Modes

show current program modes setting (same as 'm' command)

.LI Sky

paint blue sky in views.

.LI Gravity

enable gravity (default). Will affect bullets path.

.LI Instruments

show a rudimentary set of instruments.

.LI "Play Blues"

[sound debug] No simulator is complete without it. Actually used to test
the sound generation logic which for now is operational only on the PC.

.LI Verbose

set verbose mode. At the moment it means that when using the 'u' command
you will not be shown the long list of commands (the menu will not show
but it is active!).

.LI "Net Stats"

display network statistics (same as 'n' command).

.LE

.H 1 "Command Line Editing"

.P

When a command needs to receive a parameter which is more than one
keystroke it uses a line input facility. It allows you to use history
and editing. You can use the arrow keys and insert/delete keys to move
about and edit your response. The up/down keys will retrieve history.
Finally you will need to press Enter for the program to accept the
input. The history queue has 20 entries. If you key the start of a line
and hit PgUp then a search will be done for a previous entry with the
same beginning.

.H 1 "Aural Indicators"

Sound is used to inform and warn. The sounds at the moment are simple tones
or tone sequences.

.P

A short beep when:

.DL 5

.LI

you fire

.LI

you hit or a plane crash

.LI

the radar selects a target

.LI

a menu selection is invalid

.LE

.P

A low beep when:

.DL 5

.LI

landing

.LI

taking off

.LI

landing gear status is changed

.LE

.P

Two repeating tones for:

.DL 5

.LI

Emergency alarm (pull-up, eject etc.)

.LI

Warning alarm (stall, g-limit etc.)

.LE

.P

Repeating scales when:

.DL 5

.LI

target practice has ended

.LE

.H 1 "Visual Indicators"

.P

These are highlighted words flashed onto the HUD. They vary in size and
blink rate.

.VL 15 5

.LI WAIT

You ejected and landed but your plane did not yet crash. This one does
not relate to the HUD, all the others only show when the HUD is on.

.LI STALL

You are flying the plane too slow to maintain lift or you are turning
too sharply at a too high angle of attack.

.LI GLIMIT

You exceeded the maximum acceptable G force of your body (+9G to -3G),
or you exceeded the 10G plane structure limit.

.LI FUEL

You have less than 10% fuel left. The less fuel you have the faster the
message blinks, then it finally stays on.

.LI "PULL UP"

You are about to hit the ground unless you pull the plane up
immediately. If the danger is higher then a red ground grid is flashed
to give the pilot better orientation (there is not enough scenery to
build proper visual awareness).

.LI EJECT

The plane is damaged beyond control. Shift-E to eject.

.LE

.H 1 "The Plane"

.P

This chapter explains in detail how planes are handled in this program.

.P

The plane is controlled by your pointing device, preferably a joystick.
The basic controls will have the following effect:

.P

Left/right controls will cause the plane to roll. The roll will continue
while the controls are engaged. When the joystick is centered the
rolling will stop and the plane will stay in the current situation. If
you want to fly level after rolling to the right then you will have to
do the following:

.DL 5

.LI

roll right (the horizon will roll left).

.LI

stop rolling (the horizon will stay at a fixed angle).

.LI

roll left (horizon rolling back to the right).

.LI

stop rolling (when the horizon is level).

.LE

.P

As the plane has momentum, the response is not immediate and you will
have to get a feel for it.

.P

To start climbing you will pull the stick toward you until the climb
angle is what you want and then release the stick. The plane will
continue climbing until you push the nose down for level flight. If you
are rolled over to one side then the pulling will cause the plane to
turn into that side. If you are upside-down and you pull the stick then
you will start descending towards the ground. In other words: the
up/down controls (elevators) are used for any change of direction, both
left/right and up/down.

.P

To turn right, first roll right, then pull the stick until the desired
heading is reached, then release the elevators and roll back to level
flight. Of course, due to gravity and plane dynamics any change in
situation will probably cause the plane to move in a direction slighly
different from what the controls suggest - you should learn to
compensate for this. The flight-path-marker (the little circle with
three wings) tells you where the plane is heading and this is hardly
ever the direction where your plane is pointed at.

.P

To control your engine you set the throttle with the 9/3 keys. The
throttle can be set to between -100% and 100%. Reverse setting only
works on the ground. Each keystroke is 5% change. The 1 key will set the
throttle to 100% and the 0 key to 0%. The planes speed will pick up
slowly (depends on the planes weight and the engines power). You can
engage the after-burner with the '.' key. To slow down you may use the
speed brakes ('+' key).

.P

About the AfterBurner: light it with '.' (will also set throttle to
100%). Then each '.' or '3' (power-up) will add a notch. Each '9'
(power-down) will take it down a notch. There are five steps (say 20%
each). The throttle display will show '103' for '100% + AB3', 105 is
full AB. The engine display will show thrust in % of mil thrust (full AB
is about 150%-160%). If you use '1' (max throttle) or '0' (idle engine)
the ab is turned off. NOTE that AB5 uses about 6 times as much fuel as
MIL for 60% extra power!

.P

Note that with the PC keyboard and the NumLock engaged, the above keys
appear in a logical order.

.P

The Classic plane is an over-simplified vehicle. It has no momentum and
no aerodynamics characteristics, it goes where you point it and is a
good way to get the hang of the controls. It will never crash either
(you can fly underground of course). But don't get too used to it, the
real planes handle very differently (the Classic is more like a
weightless spaceship of an arcade-game).

.H 1 "The Head Up Display"

.P

The program displays a number of HUD styles. These are named according
to a plane type but this is just because I first saw this HUD on a video
tape dedicated to that plane. In reality each plane has a number of HUD
modes. You can change the HUD style through the hud menu regardless of
the plane type.

.P

The HUD is a piece of glass that is positioned at an angle in front of
the pilot. The pilot looks through it to see the front view from the
cockpit and at the same time a reflection of a video screen is seen
(this CRT is in the 'dashboard' facing up). The dual-image is similar to
when one looks outside through a window at night and sees a reflection
of some part of the room as well as the outside. The HUD can be
displayed by itself on one of the auxiliary HDDs (sometimes refered to
as the 'HUD repeater'), which is useful when the HUD optics is not
operational (damaged).

.P

In practice, the HUD is a flat image superimposed on the front view, and
it uses a special (usually green but you can change this) color. It does
not cover the full field-of-view.

.P

The image projected onto the HUD contains two kinds of information. One
type is data that the pilot will otherwise have to look for in some
cockpit instruments (thus taking his eye off the outside scene); this is
simply a way of putting the most important information if front of the
pilot. An example is the display of plane speed. The other kind is
information directly related to the outside image and meaningfull only
in relation to it, for example: a bounding box is displayed such that it
coincides with a visible target that the radar is locked on.

.P

The prominent features on the HUD are a number of scales which are
usually diaplayed along the edge. Sometimes the detail of the scales can
be controlled in three levels through the Hud menu (see there).

.P

The HUD symbols will relate to flight data or to auxiliary systems
(weapons, radar, fuel etc.). The data related to the flying of the plane
is described first.

.H 2 "Heading"

.P

Your compass. It will be shown as a horizontal ruler that moves as you
turn. The current heading is marked with a 'tick' or a 'V'. It can be at
the top or at the bottom of the HUD (Top option in Hud menu). North is
360, South is 180, East is 90 and West 270. Some modes do not show the
trailing zero (270 is shown as 27) and NO, there is no support for
radians or other units...

.H 2 "Altitude"

.P

Your height above sea level, a vertical ruler at the right edge of the
HUD. It may be accompanied by a second bar (immediately to its left)
that shows your climb/fall rate. This ruler moves up and down as the
plane moves, the current altitude is to be read at the 'tick' in its
middle. High altitudes show in thousands (with a possible decimal point)
while low ones will show exact. The FA-18 style HUD shows the altitude
in a box at the right side of the HUD with the climb rate above it. Some
HUDs will show a radar-range scale adjacent to (and to the left of) the
altitude scale. This will indicate the distance to the target (the full
scale range is shown just above this scale) as a sliding tick while the
target closure speed is shown inside the tick.

.P

Climb rate is in meters (or feet) per minute!

.H 2 "Speed"

.P

Your speed is shown as a ruler at the left edge of the HUD, a tick marks
the current value. The FA-18 style HUD shows it in the left box. Some
HUDs do not show the trailing zero while others show have the scale run
from top to bottom.

.P

This information may be in meters/kmh of feet/knots (use the Hud Knots
command to toggle). The F16/FA18 default to feet/knots.

.H 2 "Pitch ladder"

.P

The orientation of the plane is displayed as a ladder, each step relates
to a different pitch. The steps are always parallel to the horizon. Each
step is marked with a number which is your pitch angle (90 degrees is
straight up, -90 is down and zero is level). The step's angle represent
the planes roll. When you are upside-down the steps are too, as you roll
the steps turn in the opposite way to follow the horizon. The
negative-pitch steps (when you are going down) are dashed while the
positive ones are solid. Small winglets at the tips of the steps point
toward the ground. The zero-pitch step is larger and is your artifical
horizon if you cannot see the real one. The FA-18 style HUD tries a bit
harder by bending the steps toward the ground: the higher your pitch the
larger the slant. It also shows a small circle at the straight up/down
directions (the down one has a cross through it).

.P

Although the pitch ladder follows the horizon (meaning the zero-step is
on the horizon) there is some freedom in where on the horizon  to show
it. Unless you disable the velocity vector (flight path) marker (see
below), the ladder will be centered on it. This means that at a high
angle of attack the pitch ladder may be out of view (as will the vv).

.P

In the case of the FA18, if the vv goes out of view then a waterline
marker will appear at the center of the HUD (it is a W marker in a fixed
position) and the ladder will shift (smoothly) toward it. Once the vv is
back in view the ladder will return to it and the waterline mark will
disappear (the transitions take about two seconds maximum). The FA18
ladder shows an extra-long zero-step while the landing gear is down.

.H 2 "Velocity Vector"

.P

A plane rarely moves straight ahead due to gravity and aerodynamic
forces. This marker (sometimes called the 'plane marker') is a tiny
circle with wings on either side and at the top (it is a stylized shape
of a plane from behind). At any time, this marker shows you where the
plane is heading. You will most of the time use this marker as a
reference for flying the plane. The center of the view is rather useless
for flying (you can bring up a cross-hair with the 'u+' command) but can
be helpful in aiming the cannon (in the absence of the aiming reticle).

.P

The Classic plane always goes ahead, so the vv will be fixed at the center of
the HUD. By default it will not be shown for this plane.

.H 2 "Waterline mark"

.P

This is a 'W' that shows in the straight ahead point on the front view
(this is not always the physical center of the HUD). It comes on
whenever the landing gear is lowered. The FA-18 HUD shows it whenever
the Velocity Vector is outside the HUD.

.H 2 "Radar Symbology"

.P

When the radar is active, some symbols related to its operation are
displayed. The main features are the target designator box and the
aiming reticle (the Piper).

.H 3 "Target designator"

.P

This is a square that is centered on the target. If the target is not
locked then the box will have only corners. The target should be visible
inside the box, unless it is off screen. When off screen, the box has a
\'+' through it and it crawls along the HUD edge showing you the
direction where the target is. If the target is actualy behind you then
the '+' is replaced with an 'X'.

.H 3 "Aiming Reticle"

.P

If a target is close enough (within weapon range) then an aiming reticle
appears.  The reticle is a circle with 12 ticks. Each tick represents a
distance of 1000 to the target and the range is marked with a tick that
moves along the inside edge of the reticle. A tick at 11 o'clock means a
distance of 11,000 etc. You should fly the plane so that the center of
the reticle (has a dot) is on the target and then shoot (actually, the
cannon/radar computer will display 'shoot' above the reticle when you
have a good aim). If this sounds simple it is because it is a simple
procedure; the problem is that in order to get the target in the reticle
you will NOT be flying the plane directly toward it. In practice you
forget about where the plane should go and play a game of
follow-the-target with the reticle (just try and not hit the ground).

.P

Both the Classic and FA18 HUDs show a small circle which slides
around the outside of the aiming reticle to give an indication of your
heading relative to that of your target. When the small circle is
at 12 o'clock on the reticle both you and the target are heading
toward each other and when it's at 6 o'clock you're both heading in
the same direction (which hopefully means you're behind your enemy, not the
other way round). At 3 o'clock the target is crossing your path.

.P

The F16 will also show a 'hand' inside the reticle which indicates the
direction and magnitude of the target acceleration (this one is very
jittery at times). You can turn this hand on/off with the Hud menu "acc
vect" command.

.P

The FA18 HUD shows the closure speed outside the lower right side of the
reticle. The F15/F16 shows the same information on the radar range scale
(beside the altitude) marked with a large '>' symbol. The closure speed
measures how fast you are catching up (positive) with the target.

.P

However, in order to complicate the situation we have some variations
possible:

.P

There is an alternate piper: Ross's reticle. This is a different aiming
method altogether. A square reticle is shown with only the corners
visible. It is ahead of your target at all times on its projected
position. You have to aim the piper at the box and then shoot. With this
one you do not care where the real target is because the aiming box
replaces it. The piper will be fixed at the center of the HUD.  You may
want to turn off the target designator with 'ut'.

.P

The target designator and aiming reticle are part of the HUD display,
however you may choose to ignore this and request that these use the
full screen. Use the 'uL' command to limit these to inside the hud area
or use the whole screen.

.H 3 "Radar Range"

.P

The radar measures the distance and relative (closure) speed of the
target. The range is shown as an extra scale on the right side on the
HUD while the closure speed is shown beside the '>' mark on it. The FA18
HUD does not show this scale but shows the closure speed under the piper
with a 'Vc' mark.

.H 3 "Digital data"

.P

When a target is selected, some digital information may be displayed (it
can be disabled by the hud/radar menu). This data shows at the left
bottom corner of the HUD and has the following items:

.DL 5

.LI

distance to target (units or k's with one decimal)

.LI

closure speed (meters/knots)

.LI

time to meet (seconds with one decimal).

.LI

target type or pilot name

.LE

.P

When the target is in range the time shown is bullet time-to-impact
rather than plane flight time.

.P

If the Corner option is not selected (uC) then this data will show under
the target designator box. If the target is too close to the bottom then
the data may show above it.

.P

If you activate the Intel mode (i) then all visible targets get a box
with the following data (the MAP and RADAR diplays always have this mode):

.DL 5

.LI

distance to target (units or k's with one decimal)

.LI

target type or pilot name

.LE

.P

You can use 'un' to disable the display of the second line.

.P

.H 2 "Other Features"

.P

In addition to the above features, the HUD may show the following:

.P

The FA18 type HUD shows as standard, on the left low edge, the angle of
attack (aoa), the mach number and the pilot's vertical Gs. The selected
weapon (and available units) is displayed at the low center of the HUD.

.P

The F15/F16 HUD shows the aoa at the top right above the altitude scale.
The weapon selected is shown at the top of the data list ('XXX' means
none selected)

.H 1 "The ILS"

.P

The Instrument Landing System (ILS) is a system that provides enough
information about your approach to guide you to the touchdown point with
great accuracy. The system comprises two separate facilities: the
Localizer beam which tells you how well you are aligned with the runway
and the Glide Path beam which monitors your descent rate. The two
components measure your approach error and display it as two bars.

.P

The Localizer deviation bar is a vertical line that moves accross the
HUD and indicates which way of the correct line you are. If the bar is
left of center then this means that you are to the right of the
Localizer beam, so you should correct your approach to the left. When the
bar is right of center you will need to move to the right too. You are
correctly aligned when the bar is at the center. You can judge the bar's
position by noting the number of ticks along the horizontal bar. The
larger middle one is where you want to be. The bar is at full deflection
when your error is 2.5 degrees.

.P

The Glide Path deviation bar is a horizontal line that indicates where
the correct descent line is. If the line is above center then the you
should be flying higher (your descent is too rapid or you are descending
toward a point on the ground too short of the runway); you should gain
some height or reduce your descent angle. In the same way, when the line
is below HUD center you are above the correct path. The bar is at full
deflection when your error is 0.75 degrees.

.P

Note that the ILS system does not know where you are heading, it just
tells you how close you are to the correct approach path. The system
does not even know if you are coming or going! So make sure that you
approach the runway from the correct end or the ILS Localizer deviation
bar will show reverse reading and the Glide Path will direct you to land
at the far end of the runway.

.P

Real ILS systems have very narrow beams and will only operate when you
are reasonably aligned. These systems will tell you when you are out of
range. The one in Fly8 is active within a radius of about 25 kilometers
around the runway.

.P

When the ILS is operating a marker along the heading scale will direct
you to the airport; use it for the general approach but then identify
the correct runway carefully.

.P

To select the desired runway use the ILS menu and choose from the list.
There are now two airports (A is home and B is for the drones) and each
has two runways: 18 (approach at heading 180) and 27 (approach at 270).
You can turn the ILS off and it will still remember the last active
runway which will be offered when you use the command again.

.H 1 "Radar and targets"

.P

The radar in this program does NOT try to simulate a real radar. The
real thing has many types and modes of operation. This one just cheats
to get its data.

.P

When enabled ('r') the radar measures distance, direction and speed of
possible targets.

.P

In the basic mode, the radar constantly selects the closest target. This
may cause it to 'jump' between targets as they change distance. You can
put the radar in 'locked' mode ('l') which will make it stick to the
selected target. In this mode, when a target is destroyed, the nearest
target will be selected and stay locked. Use 'l' to release the lock (or
you can turn the radar off/on with 'rr').

.P

There are 3 other acquisition modes controlled by the 'f' command.

.VL 10 5

.LI 0

pick closest target (old way, as described above).

.LI 1

3.3deg circle: boresight. Only targets inside the small circle are
detected.

.LI 2

20deg circle: HUD. Any target inside the large circle (which covers most
of the HUD area) is detected.

.LI 3

5.3deg wide by 60deg high: vertical. Targets inside the narrow band
(+-5.3 degrees wide but 60 degrees tall) are detected.

.LE

.P

In modes 1-3, a target is highlighted when it is within the designated
area. The limits of the modes 1-3 are drawn on the HUD.

.P

If you are in locked mode then the first detected target will
immediately be locked, otherwise you will have to hit 'l' to lock the
highlighted target. Only when a target is locked you get the aiming
reticle (if it is close enough).

.P

It should be made clear that the 'locked' mode is set/reset by you with
the 'l' command. Once engaged, there is no need to lock on targets
because the first one to qualify will immediately be locked on. If you
want then to select another target then use 'l' to release the target
and then later 'l' to lock on the new one.

.P

Once a target is locked, the selection markings disappear and the piper
shows.

.P

A target is identified with a box around it (the target designator).
When the target is out of view the box has a large '+' crossing it which
changes to a large 'X' when the target is actually behind you.

.P

If you issue Shift-C then the plane will chase the current target (there
must be one or the plane will just patrol round the runway). Use the
\'k' command to allow automatic firing ('k' works even when not in Chase
mode, and is useful if you want to practice the chase and let the
auto-pilot do the shooting).

.P

When the reticle goes off-screen it gets a '+' inside it.

.P

You can shoot at various objects. Use the emit menu to create these
objects.

.P

When you hit something it gets damaged and fragments fall off. When
enough damage is done the object is officially HIT. It blinks red/white
and starts falling toward the ground. Practice targets are destroyed
immediately. These fragments are lethal and can hit any other object!
Normally you can fly through any object EXCEPT a bullet - so don't stay
behind a broken plane or you may be hit by the falling fragments.

.H 1 "Networking"

.P

As others said before, playing with oneself is fun but you don't make as
many friends (they said you'll go blind too).

.P

The program will let you play with others using a variety of
communication media. Once networked, objects are shared between the
players. The number of players is only limited by the capability of the
network medium.

.P

Below here, numeric parameter values can be given in C format, i.e. if
it starts with 0x it is hex, starts with 0 is octal, else it is decimal.

.P

At the bottom of the pile is the PC to PC serial connection. Only two
players can combine in this way. You can choose two drivers for this:

.P

.ti 5
\fC-ncom.N:baud:parity:bits:stop:xmode:inbuf:outbuf\fP

.P

Direct control over the com port. It can handle any speed, but slow
machines will drop charaters if you go too fast. Slow machines should
NOT use output buffering.

.P

Positional parameters:

.VL 15 5

.LI N

com port number: 1...4

.LI parity

e, o or n

.LI bits

8

.LI stop

1

.LI xmode

xon or xoff; do not specify!

.LI inbuf

4000 is enough. experiment.

.LI outbuf

very little needed if at all. Very fast machines will benefit from
output buffering, slow ones will choke unless the baud rate is low. At
115200 most machines cannot cope with output buffering.

.LE

.P

Other parameters can follow, the parameter name MUST BE GIVEN:

.VL 15 5

.LI irqN

irq number (use 4/3 as usual)

.LI baseNNN

port hardware address (use 0x3f8/0x2f8 as usual)

.LE

.P

Example:

.P

.ti 5
\fC-ncom.2:115200:n:8:1::4000::irq3:base0x2f8\fP

.P

Note that no 'xmode' was given and no 'output buffering'.

.P

If you prefer, you can use SLIP when you have SLIP8250:

.P

.in 5

.nf
\fCslip8250 0x65 -h SLIP 3 0x02f8 38400 10000\fP
\fCfly8 -r -nslip.1:0x65\fP

.fi
.in 0

.P

This is the same as

.P

.ti 5
\fCfly8 -r -nslip.1\fP

.P

because the driver will then be searched for.

.P

Slip is not too fast, you need both machines to be 386DX for full speed
and even then it is touch and go. It does no output buffering.

.P

If you have a 'real' network then install your favourite packet driver
and do

.P

.ti 5
\fCfly8 -r -npkt.1:0x65\fP

.P

In this mode you can have as many players as you wish. The program talks
packet level. It uses packet type 0x5a5a. In the future there may be
support for IP level or more (but not soon).

.P

OK, you started the program with networking. It really enjoys it but then
it is a computer. You want to enjoy it too. Here is how. The Net menu has
a set of commands for managing your connections with other players.

.VL 10 5

.LI P

This is a broadcast ping to all players. All other programs will respond
with their identification. Now you know who is active on the net. How do
you tell who's who? the parameter -Nxxx supplies your handle (nickname,
etc.) and you will be known by it in this game.

.LI Y

Request to play with another player. If there is only one then the
program will go ahead and establish connection. Otherwise you will be
prompted to select a player from a list. To have the program know who
is playing you should have used the P command first.

.LI Q

Quit playing. If there are more players then you will get a list to
choose from. An empty response will assume you want to quit all players.

.LI M

Send a message to a player. Right now, an echo message will also be sent
and the turnaround trip time (in milliseconds) will be shown. This time
is end-to-end including program delay.

.LE

.P

When you exit the program it will automatically quit all players and
notify the net of your exit.

.P

If long delays are observed then a player may be automatically timed
out. You will see messages about this. Use Y to re-establish contact.
Proper use of Q and Y will let you pop out of sight in danger and
re-join in a more favourable position...

.P

.in 5
.ll -5

IMPORTANT NOTE: the comms at this point is one-on-one. If you connect to
three other players then they all show in your world and you show in
their but they do not know of each other unless they establish
connections too. If a group plays and each one joins with a global 'Y'
then everyone will know about everyone else.

.in 0
.ll +5

.P

There is a need for proper 'game' management (co-ordination), now
completely lacking. Once on the net, you can accept/decline a player and
you can quit a player ('Q') that you do not wish to play with. See the
net menu for details.

.H 1 "Command line options"

.P

The program accepts options at start up from three sources, in order:

.VL 10 5

.LI "Init file"
.br

A file (by default 'fly.ini') is read which has a list of options. Each
option is on a separate line. A hash '#' starts a comment line, a blank
delimits the line (but leading blanks are skipped).

The file is searched for in the current directory, then in your home directory
(using the HOME variable) then in each directory along your PATH.

You can explicitly nominate a file as the first parameter on the command line
(the only parameter accepted without a preceding hyphen).

.LI "FLY8 environment variable"
.br

This variable, if defined, is a list of semicolon separated options.

.LI "Command line"
.br

Finally the command line options are accepted, each must be preceded by
a hyphen.

.LE

.P

All options can be defined in all sources. The command line looks like this:

.P

.DS
.ft C
.ti 5
fly8 -IIniFile -LLogFile -FFilesDir -MMacoFile
.ti 10
-PPlaneType -DDroneType -pPointer
.ti 10
-dVideoDriver -mVideoMode -VVideoModesFile -fFont
.ti 10
-bn -q -l -v -zNDrones -tTimeLimit -sPortIO
.ti 10
-BLineBufferSize -r -NHandle -nNetPort
.ft P
.DE

.P

The options are as follows:

.VL 15 5

.LI IIniFile

Specifies the name of an init file. The default is 'fly.ini'. The file
is searched for in the current directory, then in the home dir (uses
HOME env. var.) then the PATH directories are checked. Only the first
file found is used. This option can only be used on the command line.

.LI LLogFile

name of log file. Default is 'fly.log'. This option can only be used
the command line.

.LI MMacroFile
.br

name of keyboard macros file. This file is read at program startup and
written during shutdown. default is 'fly.mac']

.LI FFilesDir
.br

directory where the support files (*.prm, *.vxx) are found. Default is
current directory.

.LI pPointer

The pointing device can be one of: keypad, mouse, astick, bstick (but check
your specific platform). It can have options as follows [each option is one
byte, see example later]:

.VL 10 0

.LI "1  [pn]"
set x coord direction to [p]ositive or [n]egative.

.LI "2  [0-3]"
set x coord analog function (see below)

.LI "3  [pn]"
set y coord direction to [p]ositive or [n]egative.

.LI "4  [0-3]"
set y coord analog function (see below)

.LI "5  [0-9]"
set left button function (see below)

.LI "6  [0-9]"
set right button function (see below)

.LI "7  [0-9]"
set x coord sensitivity (mouse only)

.LI "8  [0-9]"
set y coord sensitivity (mouse only)

.LI "9  [01]"
1 means read joystick twice

.LE

.sp

The analog functions are:

.VL 10 0

.LI 0
right/left turn

.LI 1
up/down turn

.LE

.sp

The logical functions are:

.VL 10 0

.LI 0
power up

.LI 1
power down

.LI 2
reset (set flight direction to straight north)

.LI 3
return to origin (set x,y,z=0)

.LI 4
stop (set speed=0)

.LI 5
fire

.LI 6
rudder left

.LI 7
rudder right

.LI 8
stable (stop turning)

.LI 9
rudder to center

.LI 10
flaps

.LI 11
spoilers

.LI 12
level: cancel roll

.LI 13
air brakes

.LI 14
gnd brakes

.LI 15
gear

.LE

.sp

Example of pointer parameter (read the list bottom to top):

.sp

.DS
.ft C
.nf
 123456789 <-position
pp0p15i000=astick
^^^^^^^^^^
||||||||||
|||||||||+-- read joystick once
||||||||+--- no reading delay
|||||||+---- (unused)
||||||+----- button 2 is 'unlock'
|||||+------ button 1 is 'fire'
|||++------- positive control
|||            of up/down from second
|||            joystick input
|++--------- positive control
|              of left/right from first
|              joystick input
+----------- this is the 'pointer' parameter
.ft P
.fi
.DE

.LI "PPlaneType and DDroneType"
.br
The plane and drone type. Drone type defaults to plane type. Current
types are F15, F16, FA18 and Simple. You can create your own types.

.LI dVideoDriver
.br
the software video driver. These vary between machines.

.VL 10 0

.LI MSDOS
grqc (deflault) or grt4k (tsenglab4000 only!)

.LI MSWIN
grmswin

.LI UNIX
grx

.LI AMIGA
gramiga

.LE

.LI VVideoModesFile
.br

the xxx.vmd file to use. [default is 'fly.vmd']. This file defines the
available videomodes.

.LI mVideoMode
.br

the display video mode. This is one of the modes
defined in the .vmd file you use.

.LI fFont

name of text font file. (tsenglab4000 only!). [default is '6x8.fnt']

.LI bn

screen configuration.

.LI r

activate net.

.LI NHandle

You will be known as 'Handle'.

.LI nNetPort

Network access through driver 'NetPort'. At the moment only MSDOS has
network support.

.LI q

No sound

.LI l

add some landscaping (very rudimentary)

.LI v

verbose (not used)

.LI zNDrones

screen-blanker mode (with 'NDRONES' drones). Equivalent to setting the
screen mode 'blanker' and the emit function 'y' with 'NDrones' number.

.LI sPortIO

Sega glasses port address (com1 is 3f8, com2 is 2f8 etc.) Only in MSDOS
version.

.LI tTimeLimit
.br

time limit in seconds (use in batch demos).

.LI BLineBufferSize
.br

number of segments in the display list. Default is 5000.

.LE

.H 1 Files

.P

.VL 15 5

.LI fly.ini
.br

This file serves as an extension to the command line options.
The command-line option -I can set a user selected file name.

.LI fly.log
.br

This file logs the activity of the program, problem messages and final
stats. The command-line option -L can set a user selected file name.

.LI fly.mac
.br

This file is read at program startup and written at program shutdown.
It is the list of keyboard macros. Use the 'listmac' program to list the
contents of this file. At the moment there is no macro editor so you should
use the redefine-macro for updating. The command-line option -M can set a
user selected file name.

.LI *.vxx
.br

These files define the shape of the corresponding objects. The files MUST
reside in the current directory..

.LI *.prm
.br

These files define the behaviour of the corresponding plane type. The files
MUST reside in the current directory..

.LI fly.vmd
.br

This file defines the parameters for the available video modes. In windowed
environments this is the startup mode and you can then resize the window.
The command-line option -V can set a user selected file name.

.LE

.H 1 Acknowledgements

.P

.VL 15 5

.LI "Ross Johnson (rpj@ise.canberra.edu.au)"
.br

Ideas, testing, networking know-how, X11 help. Doco typesetting and
review.

.LI "Mike Taylor"
.br

Amiga and Windows ports.

.H 1 "Misc Notes"

.P

When you eject ('E') you will find yourself on a parachute. When you
land, you will move to a new plane. You can accelerate the descent with
\'d' but if the plane did not yet crash then you will (have to) wait on
the ground until it crashes and a new one is provided.

.P

The IBMPC uses a timer chip with three counters. Fly8 reads counter 0 to get
high resolution interval timing and writes counter 2 to generate speaker
sound. Counter 0 is often set to the wrong mode by various programs (some
examples: Landmark 1.14 sets the mode to 3 while version 2.00 sets it to
2) . The standard is mode 3, but it is sometimes set to 2. Fly8 needs to
have the timer in the standard mode or it gets bad timing information.

.P

The program 'gettimer' will report the current mode. If it is 36 or b6
then the mode is correct. The usual bad mode will show 34 or b4 (the
mode is the last digit divided by two).

.P

The program settimer will set the timer to mode 3.

.H 1 "Known Problems"
.BL 5

.LI

On a 486DX50 the serial driver fails at 115200 but is ok at 57600.
Output buffering at high speed looses the comms. It is now fixed with a
kludge in the comms driver.

.LI

On fast machines attempting to read the joystick twice in a row
produces unexpected results. A special delay option was introduced
to get around this problem.

.LI

The stroke character generator will not handle stroke sizes above
128 pixels. May be a problem if you try running at very high resolutions
(say 1600x1200).

.LE
.TC
