/* -------------------------------- body.c ---------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Handle body descriptions.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "fly.h"

extern BODY	BoGround, BoBox, BoPlane, BoRunway, BoM61, BoTarget,
		BoBroken, BoViewer, BoChute, BoHouse, BoTower, BoLow,
		BoGtarget, BoMK82, BoCrater, BoSmoke;

static int FAR
init_internals (void)
{
	st.bodies[O_GROUND]  = &BoGround;
	st.bodies[O_BOX]     = &BoBox;
	st.bodies[O_PLANE]   = &BoPlane;
	st.bodies[O_RUNWAY]  = &BoRunway;
	st.bodies[O_M61]     = &BoM61;
	st.bodies[O_TARGET]  = &BoTarget;
	st.bodies[O_BROKEN]  = &BoBroken;
	st.bodies[O_VIEWER]  = &BoViewer;
	st.bodies[O_CHUTE]   = &BoChute;
	st.bodies[O_HOUSE]   = &BoHouse;
	st.bodies[O_TOWER]   = &BoTower;
	st.bodies[O_LOW]     = &BoLow;
	st.bodies[O_GTARGET] = &BoGtarget;
	st.bodies[O_MK82]    = &BoMK82;
	st.bodies[O_CRATER]  = &BoCrater;
	st.bodies[O_SMOKE]   = &BoSmoke;
	st.bodies[O_INT]     = 0;

	return (0);
}

extern BODY * FAR
new_body (void)
{
	BODY	*b;
	ONAME	n;

	for (n = 0; st.bodies[n]; ++n)
		if (n >= O_INT+O_EXT)
			return (0);

	if (!NEW (b))
		return (0);

	st.bodies[n] = b;
	b->name = n;

	return (b);
}

extern int FAR
bodies_init (void)
{
	ONAME	i;
	Uint	extent;
	VERTEX	*v;

	if (!(st.bodies = (BODY **)xcalloc (O_INT+O_EXT+1, sizeof (BODY *))))
		return (1);

	if (init_internals ())
		return (1);

	for (i = 0; st.bodies[i]; ++i) {	/* caclulate extent */
		st.bodies[i]->name = i;
		if (st.bodies[i]->init && st.bodies[i]->init(st.bodies[i]))
			return (1);
		extent = 0;
		for (v = st.bodies[i]->shape->v; v->flags; ++v) {
			if (extent < iabs(v->V[X]))
				extent = iabs (v->V[X]);
			if (extent < iabs(v->V[Y]))
				extent = iabs (v->V[Y]);
			if (extent < iabs(v->V[Z]))
				extent = iabs (v->V[Z]);
		}
		if (st.bodies[i]->shape->flags & SH_FINE)
			extent /= VONE;
		if (0 == extent)
			extent = 1;
		st.bodies[i]->shape->extent = (int)extent;
	}
	return (0);
}

static void FAR
term_external (ONAME name)
{
	DEL0 (st.bodies[name]);
}

extern void FAR
bodies_term (void)
{
	ONAME	i;

	if (!st.bodies)
		return;

	for (i = 0; st.bodies[i]; ++i) {
		if (st.bodies[i]->term)
			st.bodies[i]->term(st.bodies[i]);
		if (i >= O_INT) {
			term_external (i);
		} else
			st.bodies[i] = 0;
	}

	st.bodies = xfree (st.bodies);
}

extern ONAME FAR
body_name (char *title)
{
	int	i;

	if (!st.bodies)
		return (-1);

	for (i = 0; st.bodies[i]; ++i) {
		if (!strcmp (st.bodies[i]->title, title))
			return (i);
	}

	return (-1);
}
