/* --------------------------------- timer.c -------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* High resolution timer services.
 * Amiga version by Michael Taylor.
*/

#include <sys/types.h>
#include <sys/timeb.h>
#include <time.h>

#include "fly.h"

#include "amigainc.h"

static struct timerequest tr;
static struct MsgPort *tport=NULL;
/*static struct Message *msg;*/

static Ulong far
timer_milli (void)
{
	unsigned long seconds, ticks;
#if 1
	/* Issue the command and wait for it to finish, then get the reply */
	DoIO((struct IORequest *) &tr);

	/* Get the results and close the timer device */
	ticks=tr.tr_time.tv_micro;
	seconds=tr.tr_time.tv_secs;
#else
	CurrentTime (&seconds, &ticks);
#endif
	return (ticks / 1000 + seconds * 1000);
}

static int far
timer_hires (void)		/* get fastest timer available */
{
	return (1);
}

static int far
timer_init (void)
{
   LONG error;
   Ulong days,hrs,secs,mins,mics;

   /* Open the MICROHZ timer device */
   error = OpenDevice(TIMERNAME,UNIT_MICROHZ,(struct IORequest *) &tr,0);
   if(error) return 1;/* If the timer will not open then just return */

   tport=(struct MsgPort *)CreatePort(0,0);
   /* If we can't get a reply port then just quit */
   if(!tport)
        {
        CloseDevice((struct IORequest *) &tr );
        return 1;
        }

   /* Fill in the IO block with command data */
   tr.tr_node.io_Message.mn_Node.ln_Type = NT_MESSAGE;
   tr.tr_node.io_Message.mn_Node.ln_Pri  = 0;
   tr.tr_node.io_Message.mn_Node.ln_Name = NULL;
   tr.tr_node.io_Message.mn_ReplyPort    = tport;
   tr.tr_node.io_Flags			 = IOF_QUICK;
   tr.tr_node.io_Command                 = TR_GETSYSTIME;

   return (0);
}

static void far
timer_term (void)
{
	if (tport) {
		DeletePort(tport);
		CloseDevice((struct IORequest *) &tr);
	}
	return;
}

static char * far
timer_ctime (void)
{
	struct timeb	tm;

	ftime (&tm);
	return (ctime (&tm.time));
}

extern struct TmDriver TmDriver = {
	"timer.device",
	0,
	timer_init,
	timer_term,
	timer_milli,
	timer_hires,
	timer_ctime
};
