//the yakPalette class; basically just an encapsulation of Themie's
//xpal (raw) routines
#include "yakPal.h"
#include "xlib.h"
#include "xpal.h"

void yakPalette::load(char * filename, yakLib * myYakLib)
{
  if(myYakLib)
  {
    byte * myTempData = myYakLib->loadToMem(filename);
    memcpy(paletteData, myTempData, 256*3);
    delete myTempData;
  }
  else
  {
    ifstream myInStream(filename);
    myInStream.read(paletteData, 256*3);
    myInStream.close();
  }
}

void yakPalette::save(char * filename)
{
    ofstream myOutStream(filename);
    myOutStream.write(paletteData, 256*3);
    myOutStream.close();
}

void yakPalette::loadDM256(char * filename)
{
    ifstream myInStream(filename);
    myInStream.seekg(19);
    myInStream.read(paletteData, 256*3);
    myInStream.close();
}

void yakPalette::get(word startColor, word numColors)
{
  x_get_pal_raw(paletteData, numColors, startColor);
}

void yakPalette::put(word startColor, word numColors)
{
  x_put_pal_raw(paletteData, (word)numColors, (word)startColor);
}

void yakPalette::rotate(direction myDirection, word startColor, word numColors)
{
  x_rot_pal_raw(paletteData + 3*startColor, myDirection, numColors);
}

void yakPalette::setColor(byte color, byte r, byte g, byte b)
{
  x_set_rgb(color, r, g, b);
}

void yakPalette::fade(char intensity, word startColor, word numColors)
{
  int myTestColor;
  byte * myBytePointer = paletteData + 3*startColor;
  while(myBytePointer != (paletteData + 3*startColor + 3*numColors))
  {
    myTestColor = (int)*myBytePointer + intensity;
    myTestColor = (myTestColor < 0) ? 0 : myTestColor;
    myTestColor = (myTestColor > 255) ? 255 : myTestColor;
    *myBytePointer = (byte)myTestColor;
    ++myBytePointer;
  }
}